# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.virtualenclaves import VirtualEnclavesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestVirtualEnclavesMgmtCommunityOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(VirtualEnclavesMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_community_get(self, resource_group):
        response = self.client.community.get(
            resource_group_name=resource_group.name,
            community_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_community_begin_create_or_update(self, resource_group):
        response = self.client.community.begin_create_or_update(
            resource_group_name=resource_group.name,
            community_name="str",
            resource={
                "location": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "addressSpace": "str",
                    "approvalSettings": {
                        "connectionCreation": "str",
                        "connectionDeletion": "str",
                        "connectionUpdate": "str",
                        "enclaveCreation": "str",
                        "enclaveDeletion": "str",
                        "endpointCreation": "str",
                        "endpointDeletion": "str",
                        "endpointUpdate": "str",
                        "maintenanceMode": "str",
                        "mandatoryApprovers": [{"approverEntraId": "str"}],
                        "minimumApproversRequired": 0,
                        "notificationOnApprovalAction": "str",
                        "notificationOnApprovalCreation": "str",
                        "notificationOnApprovalDeletion": "str",
                        "serviceCatalogDeployment": "str",
                    },
                    "communityRoleAssignments": [
                        {"roleDefinitionId": "str", "principals": [{"id": "str", "type": "User"}]}
                    ],
                    "dnsServers": ["str"],
                    "firewallSku": "str",
                    "governedServiceList": [
                        {
                            "serviceId": "str",
                            "enforcement": "Enabled",
                            "initiatives": ["str"],
                            "option": "Allow",
                            "policyAction": "AuditOnly",
                            "serviceName": "str",
                        }
                    ],
                    "maintenanceModeConfiguration": {
                        "mode": "On",
                        "justification": "Networking",
                        "principals": [{"id": "str", "type": "User"}],
                    },
                    "managedOnBehalfOfConfiguration": {"moboBrokerResources": [{"id": "str"}]},
                    "managedResourceGroupName": "str",
                    "policyOverride": "Enclave",
                    "provisioningState": "str",
                    "resourceCollection": ["str"],
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_community_begin_update(self, resource_group):
        response = self.client.community.begin_update(
            resource_group_name=resource_group.name,
            community_name="str",
            properties={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "properties": {
                    "approvalSettings": {"mandatoryApprovers": [{"approverEntraId": "str"}]},
                    "communityRoleAssignments": [
                        {"roleDefinitionId": "str", "principals": [{"id": "str", "type": "User"}]}
                    ],
                    "dnsServers": ["str"],
                    "firewallSku": "str",
                    "governedServiceList": [
                        {
                            "serviceId": "str",
                            "enforcement": "Enabled",
                            "initiatives": ["str"],
                            "option": "Allow",
                            "policyAction": "AuditOnly",
                            "serviceName": "str",
                        }
                    ],
                    "maintenanceModeConfiguration": {
                        "mode": "On",
                        "justification": "Networking",
                        "principals": [{"id": "str", "type": "User"}],
                    },
                    "policyOverride": "Enclave",
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_community_begin_delete(self, resource_group):
        response = self.client.community.begin_delete(
            resource_group_name=resource_group.name,
            community_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_community_list_by_resource_group(self, resource_group):
        response = self.client.community.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_community_list_by_subscription(self, resource_group):
        response = self.client.community.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_community_check_address_space_availability(self, resource_group):
        response = self.client.community.check_address_space_availability(
            resource_group_name=resource_group.name,
            community_name="str",
            check_address_space_availability_request={
                "communityResourceId": "str",
                "enclaveVirtualNetwork": {
                    "allowSubnetCommunication": bool,
                    "customCidrRange": "str",
                    "networkName": "str",
                    "networkSize": "str",
                    "subnetConfigurations": [
                        {
                            "networkPrefixSize": 0,
                            "subnetName": "str",
                            "addressPrefix": "str",
                            "networkSecurityGroupResourceId": "str",
                            "subnetDelegation": "str",
                            "subnetResourceId": "str",
                        }
                    ],
                },
            },
        )

        # please add some check logic here by yourself
        # ...
