/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2014, STMicroelectronics International N.V.
 * Copyright (c) 2020, Linaro Limited
 */

#ifndef XML_DATASTORAGE_API_H_
#define XML_DATASTORAGE_API_H_

#include <assert.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <tee_api_defines.h>
#include <tee_client_api.h>
#include <unistd.h>

#include "xml_common_api.h"
#include "xtest_helpers.h"
#include "xtest_test.h"

#define declare_local_vars \
	uint32_t iObjectUsage1 __maybe_unused = 0; \
	uint32_t iObjectDataFlags1 __maybe_unused = 0; \
	uint32_t iObjectDataFlags2 __maybe_unused = 0; \
	uint32_t iObjectDataFlags3 __maybe_unused = 0; \
	uint32_t iHandleFlags1 __maybe_unused = 0; \
	uint32_t iAttributeList1 __maybe_unused = 0;

#define iAttributeListEmpty	0u

#define CLIENT_APP01                    NULL

#define TEEC_UNDEFINED_ERROR 0xDEADDEAD

#define TEEC_ORIGIN_ANY_NOT_TRUSTED_APP  0x00000005

#define CMD_DS_AllocatePersistentObjectEnumerator	0x10000015
#define CMD_DS_AllocateTransientObject			0x10000001
#define CMD_DS_Check_ObjectInfo				0x100000C2
#define CMD_DS_CloseAndDeletePersistentObject		0x1000102B
#define CMD_DS_CloseAndDeletePersistentObject1		0x1000102C
#define CMD_DS_CloseObject				0x10000011
#define CMD_DS_CopyObjectAttributes			0x10000022
#define CMD_DS_CopyObjectAttributes1			0x10000009
#define CMD_DS_CreatePersistentObject			0x10000010
#define CMD_DS_FreePersistentObjectEnumerator		0x10000016
#define CMD_DS_FreeTransientObject			0x10000004
#define CMD_DS_GenerateKey				0x1000100B
#define CMD_DS_GetNextPersistentObject			0x10000019
#define CMD_DS_GetObjectBufferAttribute			0x10000008
#define CMD_DS_GetObjectInfo				0x10000023
#define CMD_DS_GetObjectInfo1				0x10000002
#define CMD_DS_GetObjectValueAttribute			0x10000012
#define CMD_DS_InitRefAttribute				0x10000006
#define CMD_DS_InitValueAttribute			0x1000101F
#define CMD_DS_OpenPersistentObject			0x10000013
#define CMD_DS_PopulateTransientObject			0x10000007
#define CMD_DS_PopulateTransientObject_BadAttrBuffer	0x10000027
#define CMD_DS_ReadObjectData				0x10001028
#define CMD_DS_RenamePersistentObject			0x10000014
#define CMD_DS_ResetPersistentObjectEnumerator		0x10000017
#define CMD_DS_ResetTransientObject			0x10000005
#define CMD_DS_RestrictObjectUsage			0x10000021
#define CMD_DS_RestrictObjectUsage1			0x10000003
#define CMD_DS_Retrieve_ObjectInfo			0x10000020
#define CMD_DS_SeekObjectData				0x10000024
#define CMD_DS_StartPersistentObjectEnumerator		0x10000018
#define CMD_DS_StoreBuffer				0x1F0000CB
#define CMD_DS_TruncateObjectData			0x10000026
#define CMD_DS_WriteObjectData				0x10000025

#define TYPE_NOT_EXISTING				0xA0000095

#define OFFSET_0			0
#define OFFSET_1			1
#define OFFSET_DOUBLE_MAX_INT32		0xFFFFFFFE
#define OFFSET_HIGH			900
#define OFFSET_HIGH_PLUS_HIGH		(OFFSET_HIGH + OFFSET_HIGH)
#define OFFSET_INITIAL_DATA_SIZE	1024
#define OFFSET_INITIAL_DATA_SIZE_PLUS_LOW (OFFSET_INITIAL_DATA_SIZE + \
					   OFFSET_LOW)
#define OFFSET_LOW			300
#define OFFSET_LOW_PLUS_HIGH		(OFFSET_LOW + OFFSET_HIGH)
#define OFFSET_LOW_PLUS_LOW		(OFFSET_LOW + OFFSET_LOW)
#define OFFSET_MAX_INT32		0x7FFFFFFF
#define OFFSET_NEG_1			-1

#define BUFFER01_SIZE			sizeof(BUFFER01)
#define BUFFER01_SIZE_EXTENDED_01	(BUFFER01_SIZE + OFFSET_LOW)
#define BUFFER01_SIZE_EXTENDED_02	(BUFFER01_SIZE + \
					 OFFSET_LOW_PLUS_HIGH - \
					 INITIAL_DATA_SIZE)
#define BUFFER_BIG_SIZE			BIG_SIZE
#define BUFFER_SIZE_TOO_SMALL		10
#define INITIAL_DATA_SIZE		1024
#define LARGER_THAN_INITIAL		1500
#define SHORTER_THAN_INITIAL		500
#define SIZE_0				0
#define SIZE_1				1

#define BUFFER_SIZE_TOO_SMALL	10
#define SIZE_0		0
#define SIZE_1		1

#define INITIAL_DATA_SIZE 1024
#define LARGER_THAN_INITIAL 1500
#define SHORTER_THAN_INITIAL 500

#define KEY_SIZE_TOO_LARGE			4096
#define SIZE_AES_192				192
#define SIZE_AES_256				256
#define SIZE_DES3_128				128
#define SIZE_DES3_192				192
#define SIZE_DES_64				64
#define SIZE_DH_KEYPAIR_1024			1024
#define SIZE_DIGEST_MD5_16			16
#define SIZE_DIGEST_SHA1_20			20
#define SIZE_DIGEST_SHA224_28			28
#define SIZE_DIGEST_SHA256_32			32
#define SIZE_DIGEST_SHA384_48			48
#define SIZE_DIGEST_SHA512_64			64
#define SIZE_DSA_SHA1_KEYPAIR_768		768
#define SIZE_DSA_SHA1_PUBLIC_KEY_768		768
#define SIZE_DSA_SHA224_KEYPAIR_2048		2048
#define SIZE_DSA_SHA224_PUBLIC_KEY_2048		2048
#define SIZE_DSA_SHA256_KEYPAIR_2048		2048
#define SIZE_DSA_SHA256_KEYPAIR_3072		3072
#define SIZE_DSA_SHA256_PUBLIC_KEY_2048		2048
#define SIZE_DSA_SHA256_PUBLIC_KEY_3072		3072
#define SIZE_ECDH_P192				192
#define SIZE_ECDH_P224				224
#define SIZE_ECDH_P256				256
#define SIZE_ECDH_P384				384
#define SIZE_ECDH_P521				521
#define SIZE_ECDSA_P192				192
#define SIZE_ECDSA_P224				224
#define SIZE_ECDSA_P256				256
#define SIZE_ECDSA_P384				384
#define SIZE_ECDSA_P521				521
#define SIZE_GENERIC_SECRET_2048		2048
#define SIZE_HMAC_MD5_256			256
#define SIZE_HMAC_SHA1_256			256
#define SIZE_HMAC_SHA224_256			256
#define SIZE_HMAC_SHA256_512			512
#define SIZE_HMAC_SHA384_512			512
#define SIZE_HMAC_SHA512_512			512
#define SIZE_RSA_KEYPAIR_1024			1024
#define SIZE_RSA_KEYPAIR_2048			2048
#define SIZE_RSA_PUBLIC_KEY_2048		2048
#define SIZE_ZERO				0
#define WRONG_ECC_SIZE				10
#define WRONG_SIZE				5

#define TEE_ERROR_TOO_SHORT_BUFFER TEE_ERROR_SHORT_BUFFER

#define TEE_ATTR_NONE (uint32_t)0

#define NOMINAL_CASE 0

#define BUFFER_ATTRIBUTE 0
#define VALUE_ATTRIBUTE 1

#define TEE_ATTR_TEST_VALUE_A	0x0000FFFF
#define TEE_ATTR_TEST_VALUE_B	0xFFFF0000

#define OBJECT_HANDLE_NULL	0
#define OBJECT_HANDLE_01	1
#define OBJECT_HANDLE_02	2
#define OBJECT_HANDLE_03	3
#define OBJECT_HANDLE_INVALID	4

#define OBJECT_INFO_01		1

#define INVALID_HANDLE		0xFFFFFF01
#define OBJECT_ENUM_NULL	0xFFFFFF00
#define OBJECT_ENUM_01		0

#define ATTRIBUTE_01		0
#define ATTRIBUTE_02		1
#define ATTRIBUTE_03		2
#define ATTRIBUTE_04		3
#define ATTRIBUTE_05		4
#define ATTRIBUTE_06		5
#define ATTRIBUTE_NONE		0xFFFFFFFF

#define BUFFER_01		0
#define BUFFER_02		1
#define BUFFER_03		2
#define BUFFER_04		3
#define BUFFER_05		4
#define BUFFER_06		5

#define iObjectUsageNone	0
#define iObjectUsageAllBitsOne	0xFFFFFFFF
#define iHandleFlagsNone	0
#define iObjectDataFlagsNone	0

struct obj_info {
	uint8_t obj_id[TEE_OBJECT_ID_MAX_LEN];
	uint32_t obj_id_len;
	uint32_t obj_type;
	uint32_t obj_size;
	uint32_t max_obj_size;
	uint32_t obj_usage;
	uint32_t data_size;
	uint32_t data_pos;
	uint32_t handle_flags;
};

#define MAX_NUM_SAVED_OBJ_INFO 4
static struct obj_info saved_obj_info[MAX_NUM_SAVED_OBJ_INFO];

static void *saved_obj_data;
static size_t saved_obj_data_size;

static TEEC_SharedMemory share_mem[1];
static TEEC_SharedMemory *SHARE_MEM01 = share_mem;
static TEEC_Session session[2];
static TEEC_Session *SESSION01 = session;
static TEEC_Session *SESSION02 = session + 1;
static TEEC_Context context[2];
static TEEC_Context *CONTEXT01 = context;
static TEEC_Context *CONTEXT02 = context + 1;

#define STORAGE_ID_NOT_EXISTING	0x01234567

#define OBJECT_ID_01		"testobject01"
#define OBJECT_ID_02		"testobject02"
#define OBJECT_ID_03		"testobject03"
#define OBJECT_ID_SR		"testobjectSR"
#define OBJECT_ID_TOO_LONG	"0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEFx"
#define EMPTY_BUFFER		NULL

#define BIG_ATTRIBUTE_BUFFER_SIZE	512

static const uint8_t
TEE_ATTR_RSA_PUBLIC_EXPONENT_VALUE_GEN_OUT_OF_RANGE_INF[] = {
	0x11, /* 17 */
};

static const uint8_t TEE_ATTR_RSA_PUBLIC_EXPONENT_VALUE_GEN_NOT_ODD[] = {
	0x01, 0x00, 0x02, /* 65538 */
};

static const uint8_t TEE_ATTR_RSA_PUBLIC_EXPONENT_VALUE_65537[] = {
	0x01, 0x00, 0x01, /* 65537 */
};

static const uint8_t TEE_ATTR_RSA_PUBLIC_EXPONENT_VALUE_NOT_GEN_DEFAULT[] = {
	0x01, 0x01, 0xd1, /* 66001 */
};

static const uint8_t TEE_ATTR_AES_192_VALUE01[] = {
	0xcd, 0xfe, 0x57, 0xb6, 0xb6, 0x2f, 0xae, 0x6b,
	0x04, 0x73, 0x40, 0xf1, 0x02, 0xd6, 0xa4, 0x8c,
	0x89, 0x5d, 0xad, 0xf2, 0x9d, 0x62, 0xef, 0x25,
};

static const uint8_t TEE_ATTR_AES_256_VALUE01[] = {
	0x60, 0x3d, 0xeb, 0x10, 0x15, 0xca, 0x71, 0xbe, 0x2b, 0x73, 0xae, 0xf0, 0x85, 0x7d, 0x77, 0x81,
	0x1f, 0x35, 0x2c, 0x07, 0x3b, 0x61, 0x08, 0xd7, 0x2d, 0x98, 0x10, 0xa3, 0x09, 0x14, 0xdf, 0xf4,
};

static const uint8_t TEE_ATTR_DES3_128_VALUE01[] = {
	0xcd, 0xfe, 0x57, 0xb6, 0xb6, 0x2f, 0xae, 0x6b,
	0x04, 0x73, 0x40, 0xf1, 0x02, 0xd6, 0xa4, 0x8c,
};

static const uint8_t TEE_ATTR_DES3_192_VALUE01[] = {
	0xcd, 0xfe, 0x57, 0xb6, 0xb6, 0x2f, 0xae, 0x6b,
	0x04, 0x73, 0x40, 0xf1, 0x02, 0xd6, 0xa4, 0x8c,
	0x89, 0x5d, 0xad, 0xf2, 0x9d, 0x62, 0xef, 0x25,
};

static const uint8_t TEE_ATTR_DES_64_VALUE01[] = {
	0xcd, 0xfe, 0x57, 0xb6, 0xb6, 0x2f, 0xae, 0x6b,
};

static const uint8_t TEE_ATTR_DH_BASE_2048_VALUE01[] = {
	0x34, 0x49, 0x90, 0x84, 0xea, 0x17, 0x68, 0x38, 0x67, 0x39, 0x4a, 0xda, 0x44, 0xd2, 0x86, 0xac,
	0x8c, 0x9c, 0x75, 0x50, 0x50, 0xdd, 0x7e, 0x8f, 0x1f, 0x42, 0x35, 0xb0, 0x46, 0x6e, 0x40, 0xa0,
	0x2f, 0x55, 0xa0, 0x9e, 0xb8, 0xf6, 0x8b, 0xc8, 0x62, 0x43, 0x7f, 0x5f, 0x45, 0xb6, 0x9f, 0xb1,
	0x2a, 0x92, 0x3e, 0xff, 0x93, 0xd1, 0xa9, 0x6c, 0x0a, 0x55, 0x51, 0x35, 0x91, 0xcc, 0xa8, 0x37,
	0x7c, 0xa2, 0xdd, 0xb5, 0x0d, 0xa0, 0xbd, 0x4a, 0xdd, 0xa1, 0x4d, 0x8b, 0xa2, 0x1e, 0x59, 0x73,
	0x49, 0x58, 0xb7, 0x23, 0xf2, 0x67, 0x3e, 0x50, 0x07, 0xab, 0xce, 0x8e, 0x4e, 0xf6, 0xdf, 0x09,
	0x98, 0x40, 0x04, 0x65, 0x25, 0x98, 0xa2, 0x93, 0x9b, 0x1e, 0x15, 0x1b, 0x8d, 0xbf, 0x0c, 0x87,
	0x80, 0xee, 0xa4, 0x0f, 0xd9, 0xe8, 0x08, 0xb6, 0xae, 0x1e, 0xcf, 0xfa, 0x73, 0x0d, 0x19, 0x3f,
	0x78, 0xc9, 0xeb, 0x7f, 0xd7, 0x28, 0x39, 0x1f, 0xa6, 0xec, 0x65, 0x15, 0xd2, 0x84, 0xc0, 0x8c,
	0x2a, 0xc1, 0x1b, 0x27, 0x3d, 0xc9, 0x70, 0x9d, 0xd7, 0x63, 0xb3, 0xe1, 0x8d, 0xbb, 0x9d, 0x5e,
	0x61, 0x1b, 0xc7, 0x83, 0xc3, 0x37, 0x38, 0x2a, 0xea, 0x6a, 0x66, 0x22, 0xe7, 0x04, 0x5b, 0x87,
	0x8b, 0x3d, 0xc5, 0x8c, 0x45, 0xd6, 0x50, 0x22, 0x80, 0xbe, 0xca, 0x16, 0x63, 0x7c, 0xdc, 0x0b,
	0xad, 0x35, 0x2e, 0xb5, 0x9b, 0xf7, 0x36, 0xfc, 0x6b, 0x17, 0xf0, 0xe2, 0x8c, 0xb6, 0x8f, 0x81,
	0x6d, 0xfa, 0x49, 0x8c, 0x5e, 0x70, 0x6e, 0x5d, 0x5f, 0xdd, 0x49, 0x81, 0xe4, 0x75, 0x2f, 0xe3,
	0x71, 0xb4, 0x2d, 0x10, 0xb5, 0xa2, 0x7e, 0x25, 0x42, 0x2e, 0x7c, 0x70, 0x00, 0x5e, 0xfc, 0x2e,
	0xc0, 0x3f, 0x21, 0x02, 0x6f, 0xe5, 0x00, 0x8b, 0xde, 0xee, 0x9b, 0x1a, 0x5a, 0x8a, 0x19, 0x40,
};

static const uint8_t TEE_ATTR_DH_BASE_VALUE01[] = {
	0x1c, 0xe0, 0xf6, 0x69, 0x26, 0x46, 0x11, 0x97, 0xef, 0x45, 0xc4, 0x65, 0x8b, 0x83, 0xb8, 0xab,
	0x04, 0xa9, 0x22, 0x42, 0x68, 0x50, 0x4d, 0x05, 0xb8, 0x19, 0x83, 0x99, 0xdd, 0x71, 0x37, 0x18,
	0xcc, 0x1f, 0x24, 0x5d, 0x47, 0x6c, 0xcf, 0x61, 0xa2, 0xf9, 0x34, 0x93, 0xf4, 0x1f, 0x55, 0x52,
	0x48, 0x65, 0x57, 0xe6, 0xd4, 0xca, 0xa8, 0x00, 0xd6, 0xd0, 0xdb, 0x3c, 0xbf, 0x5a, 0x95, 0x4b,
	0x20, 0x8a, 0x4e, 0xba, 0xf7, 0xe6, 0x49, 0xfb, 0x61, 0x24, 0xd8, 0xa2, 0x1e, 0xf2, 0xf2, 0x2b,
	0xaa, 0xae, 0x29, 0x21, 0x10, 0x19, 0x10, 0x51, 0x46, 0x47, 0x31, 0xb6, 0xcc, 0x3c, 0x93, 0xdc,
	0x6e, 0x80, 0xba, 0x16, 0x0b, 0x66, 0x64, 0xa5, 0x6c, 0xfa, 0x96, 0xea, 0xf1, 0xb2, 0x83, 0x39,
	0x8e, 0xb4, 0x61, 0x64, 0xe5, 0xe9, 0x43, 0x84, 0xee, 0x02, 0x24, 0xe7, 0x1f, 0x03, 0x7c, 0x23,
};

static const uint8_t TEE_ATTR_DH_PRIME_2048_VALUE01[] = {
	0xbb, 0xe9, 0x83, 0xd5, 0x01, 0xd1, 0xc8, 0xf3, 0x28, 0xff, 0x36, 0x1a, 0x82, 0xc8, 0x9b, 0x9f,
	0x72, 0xbe, 0x14, 0x20, 0x5e, 0x15, 0x13, 0xa0, 0x24, 0x89, 0x79, 0x0a, 0x67, 0x44, 0xd9, 0x05,
	0x59, 0x90, 0x51, 0x83, 0xf0, 0xed, 0xb5, 0x7d, 0x1a, 0x9a, 0xf4, 0x69, 0x6d, 0x82, 0xc3, 0x5f,
	0xe2, 0x97, 0x94, 0x59, 0xb9, 0xb2, 0x7a, 0x7b, 0xac, 0x6d, 0xba, 0x21, 0xe9, 0xb4, 0xe9, 0x64,
	0xd9, 0x88, 0x5c, 0xe0, 0xbf, 0x62, 0x5b, 0xd4, 0x4c, 0x0e, 0xc9, 0x0d, 0xab, 0x62, 0xe6, 0xf3,
	0x23, 0xf0, 0xa1, 0xd1, 0xda, 0x83, 0x66, 0x06, 0xd3, 0x77, 0x14, 0x00, 0x76, 0x11, 0x21, 0xb6,
	0xa5, 0x6a, 0xc5, 0x4d, 0x38, 0xbc, 0x50, 0x6a, 0x9f, 0x89, 0xd6, 0x91, 0x73, 0xee, 0x2f, 0x77,
	0x45, 0xeb, 0xcf, 0x02, 0x66, 0xd5, 0xd6, 0xc9, 0x94, 0x24, 0x6b, 0x99, 0x88, 0x0d, 0x5f, 0xe6,
	0x19, 0x53, 0x30, 0x3d, 0x01, 0x40, 0x9f, 0x4c, 0x75, 0xae, 0x7b, 0xfd, 0xd8, 0xea, 0x2d, 0x77,
	0x6d, 0x0a, 0x3a, 0x61, 0x61, 0xcb, 0x28, 0x4d, 0xa6, 0xc9, 0x2c, 0xbe, 0x45, 0x9e, 0xc5, 0xee,
	0x42, 0xcf, 0xde, 0x86, 0x68, 0x01, 0x42, 0x34, 0xc3, 0x63, 0xdd, 0xeb, 0x52, 0x44, 0xe2, 0x5e,
	0xef, 0xdd, 0x96, 0x17, 0x66, 0x90, 0xc4, 0xc9, 0xd8, 0x52, 0x45, 0x08, 0xc2, 0xc2, 0x6a, 0x44,
	0x73, 0x16, 0xad, 0x12, 0xbf, 0x90, 0xac, 0x48, 0xd3, 0xd0, 0x65, 0x8a, 0x18, 0xc9, 0x6c, 0x23,
	0x24, 0x61, 0x42, 0x01, 0xc5, 0xe5, 0x8e, 0x1d, 0x85, 0xb7, 0x40, 0x72, 0x53, 0x6d, 0x3c, 0x15,
	0x51, 0x52, 0x09, 0x38, 0x05, 0xc7, 0xf5, 0x8e, 0x9d, 0xa0, 0xf0, 0xb9, 0x41, 0x50, 0x54, 0xc6,
	0x70, 0x46, 0x31, 0x3e, 0xc6, 0x4d, 0x6f, 0x48, 0x85, 0xa4, 0x6b, 0x16, 0x15, 0x86, 0xa6, 0x99,
};

static const uint8_t TEE_ATTR_DH_PRIME_VALUE01[] = {
	0xe0, 0x01, 0xe8, 0x96, 0x7d, 0xb4, 0x93, 0x53, 0xe1, 0x6f, 0x8e, 0x89, 0x22, 0x0c, 0xce, 0xfc,
	0x5c, 0x5f, 0x12, 0xe3, 0xdf, 0xf8, 0xf1, 0xd1, 0x49, 0x90, 0x12, 0xe6, 0xef, 0x53, 0xe3, 0x1f,
	0x02, 0xea, 0xcc, 0x5a, 0xdd, 0xf3, 0x37, 0x89, 0x35, 0xc9, 0x5b, 0x21, 0xea, 0x3d, 0x6f, 0x1c,
	0xd7, 0xce, 0x63, 0x75, 0x52, 0xec, 0x38, 0x6c, 0x0e, 0x34, 0xf7, 0x36, 0xad, 0x95, 0x17, 0xef,
	0xfe, 0x5e, 0x4d, 0xa7, 0xa8, 0x6a, 0xf9, 0x0e, 0x2c, 0x22, 0x8f, 0xe4, 0xb9, 0xe6, 0xd8, 0xf8,
	0xf0, 0x2d, 0x20, 0xaf, 0x78, 0xab, 0xb6, 0x92, 0xac, 0xbc, 0x4b, 0x23, 0xfa, 0xf2, 0xc5, 0xcc,
	0xd4, 0x9a, 0x0c, 0x9a, 0x8b, 0xcd, 0x91, 0xac, 0x0c, 0x55, 0x92, 0x01, 0xe6, 0xc2, 0xfd, 0x1f,
	0x47, 0xc2, 0xcb, 0x2a, 0x88, 0xa8, 0x3c, 0x21, 0x0f, 0xc0, 0x54, 0xdb, 0x29, 0x2d, 0xbc, 0x45,
};

static const uint8_t TEE_ATTR_DH_PRIVATE_VALUE_256_2048_VALUE01[] = {
	0xd7, 0x2a, 0x8b, 0x81, 0x2b, 0x22, 0x7a, 0x7e, 0x0e, 0xc1, 0xbe, 0x32, 0xfe, 0xdc, 0xda, 0xf4,
	0xda, 0x4e, 0xe2, 0xe3, 0x6e, 0x73, 0x40, 0x28, 0x72, 0xf9, 0x46, 0x20, 0xb6, 0xd4, 0xb1, 0xdc,
};

static const uint8_t TEE_ATTR_DH_PRIVATE_VALUE_VALUE01[] = {
	0x53, 0x8d, 0x3d, 0x64, 0x27, 0x4a, 0x40, 0x05,
	0x9b, 0x9c, 0x26, 0xe9, 0x13, 0xe6, 0x91, 0x53,
	0x23, 0x7b, 0x55, 0x83,
};

static const uint8_t TEE_ATTR_DH_PUBLIC_VALUE_2048_VALUE01[] = {
	0xb4, 0x0d, 0x9a, 0x68, 0x60, 0xc3, 0x0f, 0x0c, 0x2a, 0xd3, 0x30, 0x4f, 0x4b, 0x54, 0x81, 0x26,
	0xb9, 0xba, 0x58, 0x3c, 0xeb, 0x77, 0x45, 0xe1, 0x10, 0xc6, 0xfa, 0xce, 0xb9, 0xc6, 0x91, 0x55,
	0x21, 0x3b, 0xea, 0x8a, 0x86, 0xcd, 0x5b, 0x9f, 0xc1, 0x9f, 0x64, 0xcc, 0x0d, 0x66, 0xfe, 0x33,
	0x21, 0x28, 0xbc, 0x7f, 0xfe, 0xaf, 0xd3, 0x18, 0x8c, 0x52, 0x73, 0xb4, 0xe7, 0xba, 0x50, 0x5e,
	0x98, 0x1e, 0xac, 0x7d, 0xb5, 0xf1, 0x2a, 0xd9, 0x50, 0x47, 0xfb, 0x6f, 0x1e, 0x34, 0xaa, 0x9d,
	0xff, 0x31, 0x20, 0xb8, 0x55, 0x0f, 0xc5, 0x71, 0xb9, 0x34, 0x9f, 0x23, 0x39, 0xcd, 0x96, 0xde,
	0x9c, 0x11, 0x9d, 0x0e, 0x6b, 0xe1, 0x0f, 0x69, 0x0a, 0x77, 0xc7, 0x5a, 0xed, 0xc5, 0x2a, 0x95,
	0x90, 0xc7, 0x92, 0x94, 0xf8, 0x03, 0x81, 0xaa, 0xfc, 0x34, 0x3c, 0xec, 0x6b, 0x62, 0x4d, 0x03,
	0x7a, 0x6a, 0x7c, 0x92, 0xf7, 0x2c, 0x38, 0x84, 0x33, 0x7e, 0xf3, 0xfd, 0xae, 0x20, 0xb0, 0xc6,
	0x60, 0x76, 0x53, 0x60, 0xf3, 0x77, 0x50, 0x96, 0x0d, 0xbc, 0x40, 0xe4, 0x99, 0xfc, 0xe5, 0x79,
	0xda, 0x3b, 0x65, 0x98, 0xfe, 0x28, 0x68, 0x68, 0xc6, 0x87, 0xbb, 0xc8, 0x12, 0x7c, 0x1d, 0x0b,
	0x42, 0xe9, 0xb4, 0x6c, 0xd9, 0x1b, 0x23, 0xba, 0x34, 0x59, 0x3b, 0x86, 0x60, 0x45, 0xb6, 0x25,
	0x48, 0x53, 0x7c, 0xc7, 0xf8, 0x24, 0xb8, 0xf6, 0x71, 0xb5, 0x42, 0x98, 0xde, 0x8c, 0x6e, 0x61,
	0x7e, 0x1b, 0xf9, 0xab, 0x52, 0x4f, 0x03, 0xd1, 0xde, 0x30, 0xb4, 0x85, 0xa7, 0x3b, 0x97, 0xda,
	0x97, 0x5f, 0xbe, 0x8a, 0xd6, 0x2e, 0x19, 0x91, 0x29, 0xb4, 0x66, 0x6d, 0x03, 0x73, 0x43, 0xbe,
	0x13, 0x47, 0x82, 0x20, 0x80, 0x21, 0xf2, 0x3e, 0xbc, 0x66, 0xa6, 0x07, 0x38, 0x71, 0x77, 0xe4,
};

static const uint8_t TEE_ATTR_DH_PUBLIC_VALUE_VALUE01[] = {
	0xbb, 0xe9, 0x18, 0xdd, 0x4b, 0x2b, 0x94, 0x1b, 0x10, 0x0e, 0x88, 0x35, 0x28, 0x68, 0xfc, 0x62,
	0x04, 0x38, 0xa6, 0xdb, 0x32, 0xa6, 0x9e, 0xee, 0x6c, 0x6f, 0x45, 0x1c, 0xa3, 0xa6, 0xd5, 0x37,
	0x77, 0x75, 0x5b, 0xc1, 0x37, 0x0a, 0xce, 0xfe, 0x2b, 0x8f, 0x13, 0xa9, 0x14, 0x2c, 0x5b, 0x44,
	0x15, 0x78, 0x86, 0x30, 0xd6, 0x95, 0xb1, 0x92, 0x20, 0x63, 0xa3, 0xcf, 0x9d, 0xef, 0x65, 0x61,
	0x27, 0x4d, 0x24, 0x01, 0xe7, 0xa1, 0x45, 0xf2, 0xd8, 0xb9, 0x3a, 0x45, 0x17, 0xf4, 0x19, 0xd0,
	0x5e, 0xf8, 0xcb, 0x35, 0x59, 0x37, 0x9d, 0x04, 0x20, 0xa3, 0xbf, 0x02, 0xad, 0xfe, 0xa8, 0x60,
	0xb2, 0xc3, 0xee, 0x85, 0x58, 0x90, 0xf3, 0xb5, 0x57, 0x2b, 0xb4, 0xef, 0xd7, 0x8f, 0x37, 0x68,
	0x78, 0x7c, 0x71, 0x52, 0x9d, 0x5e, 0x0a, 0x61, 0x4f, 0x09, 0x89, 0x92, 0x39, 0xf7, 0x4b, 0x01,
};

static const uint8_t TEE_ATTR_DH_PUBLIC_VALUE_VALUE02[] = {
	0xa3, 0xf5, 0x7d, 0xbe, 0x9e, 0x2f, 0x0a, 0xda, 0xa9, 0x4e, 0x4e, 0x6a, 0xf0, 0xe0, 0x71, 0x47,
	0x0e, 0x2e, 0x41, 0x2e, 0xde, 0x73, 0x2a, 0x62, 0x14, 0xc3, 0x7c, 0x26, 0xd4, 0xe9, 0x9a, 0x54,
	0xba, 0x3d, 0xe7, 0x49, 0x85, 0x95, 0x0e, 0xe9, 0x14, 0xb2, 0x90, 0x22, 0x91, 0xdc, 0xff, 0x61,
	0xb2, 0xfc, 0xd1, 0xd0, 0x1b, 0x11, 0x14, 0xb6, 0x02, 0x64, 0x2b, 0x26, 0x5d, 0x88, 0xea, 0x8d,
	0xbb, 0xe2, 0x07, 0x0b, 0x48, 0xfb, 0x01, 0x53, 0x55, 0x1e, 0x59, 0x51, 0x36, 0xf2, 0xf9, 0xd1,
	0x97, 0xfb, 0x66, 0x12, 0x84, 0x5d, 0xed, 0xb8, 0x9b, 0x2d, 0x3e, 0x2b, 0x8c, 0xeb, 0x2a, 0x72,
	0x40, 0x9d, 0x55, 0x4c, 0xed, 0xeb, 0x55, 0x02, 0xff, 0x8c, 0xb0, 0x2e, 0x03, 0x65, 0x3f, 0x41,
	0xb1, 0xac, 0xa3, 0x30, 0x6b, 0xff, 0x6d, 0xf4, 0x6d, 0xe6, 0xe1, 0x0f, 0x86, 0x7c, 0x43, 0x64,
};

static const uint8_t TEE_ATTR_DH_SUBPRIME_VALUE01[] = {
	0x84, 0xbb, 0x73, 0xca, 0x02, 0xa8, 0x6e, 0x8b,
	0xef, 0x44, 0x72, 0x06, 0xe0, 0xbe, 0xd2, 0x0e,
	0xeb, 0x47, 0x9f, 0x4d,
};

static const uint8_t TEE_ATTR_DSA_BASE_2048_VALUE01[] = {
	0x20, 0x42, 0x09, 0x4c, 0xcb, 0xc8, 0xb8, 0x72, 0x3f, 0xc9, 0x28, 0xc1, 0x2f, 0xda, 0x67, 0x1b,
	0x83, 0x29, 0x5e, 0x99, 0xc7, 0x43, 0x57, 0x6f, 0x44, 0x50, 0x4b, 0xe1, 0x18, 0x63, 0x23, 0x31,
	0x9b, 0x50, 0x02, 0xd2, 0x4f, 0x17, 0x3d, 0xf9, 0x09, 0xea, 0x24, 0x1d, 0x6e, 0xa5, 0x28, 0x99,
	0x04, 0xee, 0x46, 0x36, 0x20, 0x4b, 0x2f, 0xbe, 0x94, 0xb0, 0x68, 0xfe, 0x09, 0x3f, 0x79, 0x62,
	0x57, 0x95, 0x49, 0x55, 0x1d, 0x3a, 0xf2, 0x19, 0xad, 0x8e, 0xd1, 0x99, 0x39, 0xef, 0xf8, 0x6b,
	0xce, 0xc8, 0x34, 0xde, 0x2f, 0x2f, 0x78, 0x59, 0x6e, 0x89, 0xe7, 0xcb, 0x52, 0xc5, 0x24, 0xe1,
	0x77, 0x09, 0x8a, 0x56, 0xc2, 0x32, 0xeb, 0x1f, 0x56, 0x3a, 0xa8, 0x4b, 0xc6, 0xb0, 0x26, 0xde,
	0xee, 0x6f, 0xf5, 0x1c, 0xb4, 0x41, 0xe0, 0x80, 0xf2, 0xda, 0xfa, 0xea, 0x1c, 0xed, 0x86, 0x42,
	0x7d, 0x1c, 0x34, 0x6b, 0xe5, 0x5c, 0x66, 0x80, 0x3d, 0x4b, 0x76, 0xd1, 0x33, 0xcd, 0x44, 0x5b,
	0x4c, 0x34, 0x82, 0xfa, 0x41, 0x50, 0x23, 0x46, 0x3c, 0x9b, 0xf3, 0x0f, 0x2f, 0x78, 0x42, 0x23,
	0xe2, 0x60, 0x57, 0xd3, 0xaa, 0x0d, 0x7f, 0xbb, 0x66, 0x06, 0x30, 0xc5, 0x2e, 0x49, 0xd4, 0xa0,
	0x32, 0x5c, 0x73, 0x89, 0xe0, 0x72, 0xaa, 0x34, 0x9f, 0x13, 0xc9, 0x66, 0xe1, 0x59, 0x75, 0x2f,
	0xbb, 0x71, 0xe9, 0x33, 0x68, 0x90, 0xf9, 0x32, 0x43, 0xfa, 0x6e, 0x72, 0xd2, 0x99, 0x36, 0x5e,
	0xe5, 0xb3, 0xfe, 0x26, 0x6e, 0xbf, 0x11, 0x10, 0x56, 0x8f, 0xee, 0x44, 0x25, 0xc8, 0x47, 0xb5,
	0x02, 0x10, 0xbd, 0x48, 0x4b, 0x97, 0x43, 0x1a, 0x42, 0x85, 0x6a, 0xdc, 0xa3, 0xe7, 0xd1, 0xa9,
	0xc9, 0xc6, 0x75, 0xc7, 0xe2, 0x66, 0x91, 0x83, 0x20, 0xdd, 0x5a, 0x78, 0xa4, 0x8c, 0x48, 0xa9,
};

static const uint8_t TEE_ATTR_DSA_BASE_3072_VALUE01[] = {
	0x11, 0x0a, 0xfe, 0xbb, 0x12, 0xc7, 0xf8, 0x62, 0xb6, 0xde, 0x03, 0xd4, 0x7f, 0xdb, 0xc3, 0x32, 0x6e, 0x0d, 0x4d, 0x31, 0xb1, 0x2a, 0x8c, 0xa9,
	0x5b, 0x2d, 0xee, 0x21, 0x23, 0xbc, 0xc6, 0x67, 0xd4, 0xf7, 0x2c, 0x1e, 0x72, 0x09, 0x76, 0x7d, 0x27, 0x21, 0xf9, 0x5f, 0xbd, 0x9a, 0x4d, 0x03,
	0x23, 0x6d, 0x54, 0x17, 0x4f, 0xbf, 0xaf, 0xf2, 0xc4, 0xff, 0x7d, 0xea, 0xe4, 0x73, 0x8b, 0x20, 0xd9, 0xf3, 0x7b, 0xf0, 0xa1, 0x13, 0x4c, 0x28,
	0x8b, 0x42, 0x0a, 0xf0, 0xb5, 0x79, 0x2e, 0x47, 0xa9, 0x25, 0x13, 0xc0, 0x41, 0x3f, 0x34, 0x6a, 0x4e, 0xdb, 0xab, 0x2c, 0x45, 0xbd, 0xca, 0x13,
	0xf5, 0x34, 0x1c, 0x2b, 0x55, 0xb8, 0xba, 0x54, 0x93, 0x2b, 0x92, 0x17, 0xb5, 0xa8, 0x59, 0xe5, 0x53, 0xf1, 0x4b, 0xb8, 0xc1, 0x20, 0xfb, 0xb9,
	0xd9, 0x99, 0x09, 0xdf, 0xf5, 0xea, 0x68, 0xe1, 0x4b, 0x37, 0x99, 0x64, 0xfd, 0x3f, 0x38, 0x61, 0xe5, 0xba, 0x5c, 0xc9, 0x70, 0xc4, 0xa1, 0x80,
	0xee, 0xf5, 0x44, 0x28, 0x70, 0x39, 0x61, 0x02, 0x1e, 0x7b, 0xd6, 0x8c, 0xb6, 0x37, 0x92, 0x7b, 0x8c, 0xbe, 0xe6, 0x80, 0x5f, 0xa2, 0x72, 0x85,
	0xbf, 0xee, 0x4d, 0x1e, 0xf7, 0x0e, 0x02, 0xc1, 0xa1, 0x8a, 0x7c, 0xd7, 0x8b, 0xef, 0x1d, 0xd9, 0xcd, 0xad, 0x45, 0xdd, 0xe9, 0xcd, 0x69, 0x07,
	0x55, 0x05, 0x0f, 0xc4, 0x66, 0x29, 0x37, 0xee, 0x1d, 0x6f, 0x4d, 0xb1, 0x28, 0x07, 0xcc, 0xc9, 0x5b, 0xc4, 0x35, 0xf1, 0x1b, 0x71, 0xe7, 0x08,
	0x60, 0x48, 0xb1, 0xda, 0xb5, 0x91, 0x3c, 0x60, 0x55, 0x01, 0x2d, 0xe8, 0x2e, 0x43, 0xa4, 0xe5, 0x0c, 0xf9, 0x3f, 0xef, 0xf5, 0xdc, 0xab, 0x81,
	0x4a, 0xbc, 0x22, 0x4c, 0x5e, 0x00, 0x25, 0xbd, 0x86, 0x8c, 0x3f, 0xc5, 0x92, 0x04, 0x1b, 0xba, 0x04, 0x74, 0x7c, 0x10, 0xaf, 0x51, 0x3f, 0xc3,
	0x6e, 0x4d, 0x91, 0xc6, 0x3e, 0xe5, 0x25, 0x34, 0x22, 0xcf, 0x40, 0x63, 0x39, 0x8d, 0x77, 0xc5, 0x2f, 0xcb, 0x01, 0x14, 0x27, 0xcb, 0xfc, 0xfa,
	0x67, 0xb1, 0xb2, 0xc2, 0xd1, 0xaa, 0x4a, 0x3d, 0xa7, 0x26, 0x45, 0xcb, 0x1c, 0x76, 0x70, 0x36, 0x05, 0x4e, 0x2f, 0x31, 0xf8, 0x86, 0x65, 0xa5,
	0x44, 0x61, 0xc8, 0x85, 0xfb, 0x32, 0x19, 0xd5, 0xad, 0x87, 0x48, 0xa0, 0x11, 0x58, 0xf6, 0xc7, 0xc0, 0xdf, 0x5a, 0x8c, 0x90, 0x8b, 0xa8, 0xc3,
	0xe5, 0x36, 0x82, 0x24, 0x28, 0x88, 0x6c, 0x7b, 0x50, 0x0b, 0xbc, 0x15, 0xb4, 0x9d, 0xf7, 0x46, 0xb9, 0xde, 0x5a, 0x78, 0xfe, 0x3b, 0x4f, 0x69,
	0x91, 0xd0, 0x11, 0x0c, 0x3c, 0xbf, 0xf4, 0x58, 0x03, 0x9d, 0xc3, 0x62, 0x61, 0xcf, 0x46, 0xaf, 0x4b, 0xc2, 0x51, 0x53, 0x68, 0xf4, 0xab, 0xb7,
};

static const uint8_t TEE_ATTR_DSA_BASE_768_VALUE01[] = {
	0x9a, 0x09, 0x32, 0xb3, 0x8c, 0xb2, 0x10, 0x5b, 0x93, 0x00, 0xdc, 0xb8, 0x66, 0xc0,
	0x66, 0xd9, 0xce, 0xc6, 0x43, 0x19, 0x2f, 0xcb, 0x28, 0x34, 0xa1, 0x23, 0x9d, 0xba, 0x28,
	0xbd, 0x09, 0xfe, 0x01, 0x00, 0x1e, 0x04, 0x51, 0xf9, 0xd6, 0x35, 0x1f, 0x6e, 0x56, 0x4a,
	0xfb, 0xc8, 0xf8, 0xc3, 0x9b, 0x10, 0x59, 0x86, 0x3e, 0xbd, 0x09, 0x85, 0x09, 0x0b, 0xd5,
	0x5c, 0x82, 0x8e, 0x9f, 0xc1, 0x57, 0xac, 0x7d, 0xa3, 0xcf, 0xc2, 0x89, 0x2a, 0x0e, 0xd9,
	0xb9, 0x32, 0x39, 0x05, 0x82, 0xf2, 0x97, 0x1e, 0x4a, 0x0c, 0x48, 0x3e, 0x06, 0x22, 0xd7,
	0x31, 0x66, 0xbf, 0x62, 0xa5, 0x9f, 0x26,
};

static const uint8_t TEE_ATTR_DSA_PRIME_2048_VALUE01[] = {
	0xaa, 0x81, 0x5c, 0x9d, 0xb1, 0xc4, 0xd3, 0xd2, 0x77, 0x3c, 0x7d, 0x0d, 0x4d, 0x1d, 0xa7, 0x5e,
	0xcf, 0xc4, 0xa3, 0x9e, 0x97, 0xd5, 0xfa, 0x19, 0x1f, 0xfe, 0xc8, 0xb1, 0x49, 0x0a, 0x29, 0x0c,
	0xe3, 0x35, 0xe5, 0xce, 0x87, 0xea, 0x62, 0x0a, 0x8a, 0x17, 0xde, 0x0b, 0xb6, 0x47, 0x14, 0xe2,
	0xec, 0x84, 0x0b, 0xf0, 0x0e, 0x6e, 0xbd, 0xb4, 0xff, 0xb4, 0xe3, 0x24, 0xca, 0x07, 0xc3, 0xc8,
	0x71, 0x73, 0x09, 0xaf, 0x14, 0x10, 0x36, 0x2a, 0x77, 0x2c, 0x9a, 0xdd, 0x83, 0x8b, 0x2b, 0x0c,
	0xae, 0x1e, 0x90, 0xab, 0x44, 0x8a, 0xda, 0xbd, 0xac, 0xd2, 0xe5, 0xdf, 0x59, 0xc4, 0x18, 0x7a,
	0x32, 0xa2, 0x37, 0x19, 0xd6, 0xc5, 0x7e, 0x94, 0x00, 0x88, 0x53, 0x83, 0xbf, 0x8f, 0x06, 0x6f,
	0x23, 0xb9, 0x41, 0x92, 0x0d, 0x54, 0xc3, 0x5b, 0x4f, 0x7c, 0xc5, 0x04, 0x4f, 0x3b, 0x40, 0xf1,
	0x70, 0x46, 0x95, 0x63, 0x07, 0xb7, 0x48, 0xe8, 0x40, 0x73, 0x28, 0x44, 0xd0, 0x0a, 0x9c, 0xe6,
	0xec, 0x57, 0x14, 0x29, 0x3b, 0x62, 0x65, 0x14, 0x7f, 0x15, 0xc6, 0x7f, 0x4b, 0xe3, 0x8b, 0x08,
	0x2b, 0x55, 0xfd, 0xea, 0xdb, 0x61, 0x24, 0x68, 0x9f, 0xb7, 0x6f, 0x9d, 0x25, 0xcc, 0x28, 0xb8,
	0xea, 0xa9, 0x8b, 0x56, 0x2d, 0x5c, 0x10, 0x11, 0xe0, 0xdc, 0xf9, 0xb3, 0x99, 0x23, 0x24, 0x0d,
	0x33, 0x2d, 0x89, 0xdc, 0x96, 0x03, 0xb7, 0xbd, 0xdd, 0x0c, 0x70, 0xb8, 0x3c, 0xaa, 0x29, 0x05,
	0x63, 0x1b, 0x1c, 0x83, 0xca, 0xbb, 0xae, 0x6c, 0x0c, 0x0c, 0x2e, 0xfe, 0x8f, 0x58, 0x13, 0x1e,
	0xd8, 0x35, 0x1b, 0xf9, 0x3e, 0x87, 0x5f, 0x6a, 0x73, 0xa9, 0x3c, 0xba, 0xd4, 0x70, 0x14, 0x1a,
	0x26, 0x87, 0xfb, 0xac, 0xf2, 0xd7, 0x1c, 0x8d, 0xde, 0xe9, 0x71, 0xad, 0x66, 0x07, 0x29, 0xad,
};

static const uint8_t TEE_ATTR_DSA_PRIME_3072_VALUE01[] = {
	0xc7, 0xb8, 0x6d, 0x70, 0x44, 0x21, 0x8e, 0x36, 0x74, 0x53, 0xd2, 0x10, 0xe7, 0x64, 0x33, 0xe4, 0xe2, 0x7a, 0x98, 0x3d, 0xb1, 0xc5, 0x60, 0xbb,
	0x97, 0x55, 0xa8, 0xfb, 0x7d, 0x81, 0x99, 0x12, 0xc5, 0x6c, 0xfe, 0x00, 0x2a, 0xb1, 0xff, 0x3f, 0x72, 0x16, 0x5b, 0x94, 0x3c, 0x0b, 0x28, 0xed,
	0x46, 0x03, 0x9a, 0x07, 0xde, 0x50, 0x7d, 0x7a, 0x29, 0xf7, 0x38, 0x60, 0x3d, 0xec, 0xd1, 0x27, 0x03, 0x80, 0xa4, 0x1f, 0x97, 0x1f, 0x25, 0x92,
	0x66, 0x1a, 0x64, 0xba, 0x2f, 0x35, 0x1d, 0x9a, 0x69, 0xe5, 0x1a, 0x88, 0x8a, 0x05, 0x15, 0x6b, 0x7f, 0xe1, 0x56, 0x3c, 0x4b, 0x77, 0xee, 0x93,
	0xa4, 0x49, 0x49, 0x13, 0x84, 0x38, 0xa2, 0xab, 0x8b, 0xdc, 0xfc, 0x49, 0xb4, 0xe7, 0x8d, 0x1c, 0xde, 0x76, 0x6e, 0x54, 0x98, 0x47, 0x60, 0x05,
	0x7d, 0x76, 0xcd, 0x74, 0x0c, 0x94, 0xa4, 0xdd, 0x25, 0xa4, 0x6a, 0xa7, 0x7b, 0x18, 0xe9, 0xd7, 0x07, 0xd6, 0x73, 0x84, 0x97, 0xd4, 0xea, 0xc3,
	0x64, 0xf4, 0x79, 0x2d, 0x97, 0x66, 0xa1, 0x6a, 0x0e, 0x23, 0x48, 0x07, 0xe9, 0x6b, 0x8c, 0x64, 0xd4, 0x04, 0xbb, 0xdb, 0x87, 0x6e, 0x39, 0xb5,
	0x79, 0x9e, 0xf5, 0x3f, 0xe6, 0xcb, 0x9b, 0xab, 0x62, 0xef, 0x19, 0xfd, 0xcc, 0x2b, 0xdd, 0x90, 0x5b, 0xed, 0xa1, 0x3b, 0x9e, 0xf7, 0xac, 0x35,
	0xf1, 0xf5, 0x57, 0xcb, 0x0d, 0xc4, 0x58, 0xc0, 0x19, 0xe2, 0xbc, 0x19, 0xa9, 0xf5, 0xdf, 0xc1, 0xe4, 0xec, 0xa9, 0xe6, 0xd4, 0x66, 0x56, 0x41,
	0x24, 0x30, 0x4a, 0x31, 0xf0, 0x38, 0x60, 0x5a, 0x3e, 0x34, 0x2d, 0xa0, 0x1b, 0xe1, 0xc2, 0xb5, 0x45, 0x61, 0x0e, 0xdd, 0x2c, 0x13, 0x97, 0xa3,
	0xc8, 0x39, 0x65, 0x88, 0xc6, 0x32, 0x9e, 0xfe, 0xb4, 0xe1, 0x65, 0xaf, 0x5b, 0x36, 0x8a, 0x39, 0xa8, 0x8e, 0x48, 0x88, 0xe3, 0x9f, 0x40, 0xbb,
	0x3d, 0xe4, 0xeb, 0x14, 0x16, 0x67, 0x2f, 0x99, 0x9f, 0xea, 0xd3, 0x7a, 0xef, 0x1c, 0xa9, 0x64, 0x3f, 0xf3, 0x2c, 0xdb, 0xc0, 0xfc, 0xeb, 0xe6,
	0x28, 0xd7, 0xe4, 0x6d, 0x28, 0x1a, 0x98, 0x9d, 0x43, 0xdd, 0x21, 0x43, 0x21, 0x51, 0xaf, 0x68, 0xbe, 0x3f, 0x6d, 0x56, 0xac, 0xfb, 0xdb, 0x6c,
	0x97, 0xd8, 0x7f, 0xcb, 0x5e, 0x62, 0x91, 0xbf, 0x8b, 0x4e, 0xe1, 0x27, 0x5a, 0xe0, 0xeb, 0x43, 0x83, 0xcc, 0x75, 0x39, 0x03, 0xc8, 0xd2, 0x9f,
	0x4a, 0xdb, 0x6a, 0x54, 0x7e, 0x40, 0x5d, 0xec, 0xdf, 0xf2, 0x88, 0xc5, 0xf6, 0xc7, 0xaa, 0x30, 0xdc, 0xb1, 0x2f, 0x84, 0xd3, 0x92, 0x49, 0x3a,
	0x70, 0x93, 0x33, 0x17, 0xc0, 0xf5, 0xe6, 0x55, 0x26, 0x01, 0xfa, 0xe1, 0x8f, 0x17, 0xe6, 0xe5, 0xbb, 0x6b, 0xf3, 0x96, 0xd3, 0x2d, 0x8a, 0xb9,
};

static const uint8_t TEE_ATTR_DSA_PRIME_768_VALUE01[] = {
	0xf6, 0xad, 0x20, 0x71, 0xe1, 0x5a, 0x4b, 0x9c, 0x2b, 0x7e, 0x53, 0x26, 0xda, 0x43,
	0x9d, 0xc1, 0x47, 0x4c, 0x1a, 0xd1, 0x6f, 0x2f, 0x85, 0xe9, 0x2c, 0xea, 0x89, 0xfc, 0xdc,
	0x74, 0x66, 0x11, 0xcf, 0x30, 0xdd, 0xc8, 0x5e, 0x33, 0xf5, 0x83, 0xc1, 0x9d, 0x10, 0xbc,
	0x1a, 0xc3, 0x93, 0x22, 0x26, 0x24, 0x6f, 0xa7, 0xb9, 0xe0, 0xdd, 0x25, 0x77, 0xb5, 0xf4,
	0x27, 0x59, 0x4c, 0x39, 0xfa, 0xeb, 0xfc, 0x59, 0x8a, 0x32, 0xe1, 0x74, 0xcb, 0x8a, 0x68,
	0x03, 0x57, 0xf8, 0x62, 0xf2, 0x0b, 0x6e, 0x84, 0x32, 0xa5, 0x30, 0x65, 0x2f, 0x1c, 0x21,
	0x39, 0xae, 0x1f, 0xaf, 0x76, 0x8b, 0x83,
};

static const uint8_t TEE_ATTR_DSA_PRIVATE_VALUE_160_VALUE01[] = {
	0x70, 0x4a, 0x46, 0xc6, 0x25, 0x2a, 0x95, 0xa3, 0x9b, 0x40, 0xe0, 0x43, 0x5a, 0x69, 0x1b,
	0xad, 0xae, 0x52, 0xa5, 0xc0,
};

static const uint8_t TEE_ATTR_DSA_PRIVATE_VALUE_224_VALUE01[] = {
	0x7b, 0x48, 0x90, 0x21, 0x57, 0x8e, 0x79, 0xe7, 0xbd, 0x3e, 0xe7, 0xab, 0x45, 0x6f,
	0x65, 0x9f, 0x3d, 0xc0, 0x7c, 0x88, 0xf5, 0xc9, 0xa3, 0x9e, 0x4f, 0x8c, 0xee, 0x81,
};

static const uint8_t TEE_ATTR_DSA_PRIVATE_VALUE_256_VALUE01[] = {
	0x34, 0x70, 0x83, 0x20, 0x55, 0xda, 0xde, 0x94, 0xe1, 0x4c, 0xd8, 0x77, 0x71, 0x71, 0xd1, 0x8e,
	0x5d, 0x06, 0xf6, 0x6a, 0xef, 0xf4, 0xc6, 0x14, 0x71, 0xe4, 0xeb, 0xa7, 0x4e, 0xe5, 0x61, 0x64,
};

static const uint8_t TEE_ATTR_DSA_PUBLIC_VALUE_2048_VALUE01[] = {
	0x1a, 0xe1, 0x0c, 0x78, 0x6a, 0xd0, 0x90, 0x2c, 0x5c, 0x68, 0x5d, 0xae, 0x5c, 0x71, 0x21, 0x41,
	0x8a, 0x37, 0x7b, 0x88, 0x8b, 0x5f, 0x2f, 0x2b, 0xc7, 0x66, 0x23, 0x57, 0x0f, 0xd6, 0x2b, 0xcb,
	0x19, 0x0b, 0x47, 0x1a, 0xd5, 0x35, 0x9c, 0x5f, 0x06, 0x2f, 0x88, 0x19, 0x28, 0x9e, 0x95, 0x6d,
	0x8a, 0xa6, 0xf9, 0x0d, 0x1f, 0x8c, 0xf1, 0xee, 0x72, 0xd3, 0xa1, 0xbd, 0xfd, 0x56, 0xc4, 0x78,
	0xdc, 0x29, 0xa1, 0x9c, 0x45, 0x69, 0xb5, 0xa6, 0x0e, 0x3a, 0x8f, 0x34, 0xf6, 0x06, 0x56, 0xea,
	0xc5, 0xb2, 0x5d, 0xde, 0x55, 0x14, 0xa5, 0xc6, 0x7b, 0x67, 0x54, 0x23, 0x20, 0x4f, 0x6c, 0xca,
	0xf0, 0x99, 0x06, 0x17, 0xcc, 0x73, 0x55, 0xb9, 0xd3, 0xed, 0x86, 0x89, 0x78, 0xa2, 0x52, 0x02,
	0x0a, 0x76, 0x9e, 0xd5, 0x9a, 0x6e, 0xda, 0xa6, 0xef, 0xe3, 0x37, 0x7e, 0xef, 0x45, 0xf3, 0xf6,
	0xf3, 0xe6, 0x41, 0x79, 0xcc, 0x7d, 0xb8, 0xb1, 0x43, 0xfb, 0x83, 0x5c, 0x5d, 0x71, 0xbf, 0xcf,
	0xa1, 0xe2, 0xa9, 0x04, 0x9b, 0xcc, 0xf7, 0xfe, 0x9a, 0xb5, 0x75, 0x46, 0x22, 0x0f, 0xe3, 0xf4,
	0xb7, 0x52, 0x1c, 0x86, 0x17, 0x39, 0xd1, 0x38, 0x50, 0x7e, 0x81, 0xa4, 0x6a, 0x69, 0x93, 0x60,
	0x54, 0x41, 0xdc, 0xb9, 0x0d, 0x6e, 0xe4, 0xaf, 0xbc, 0x42, 0xca, 0xbe, 0x90, 0xa2, 0x54, 0x44,
	0x49, 0x68, 0x10, 0x9d, 0x7e, 0xdd, 0x96, 0x94, 0xa0, 0x23, 0x23, 0x9f, 0x1d, 0x56, 0x17, 0x5d,
	0xd1, 0xfa, 0xc1, 0x15, 0x91, 0x5e, 0x24, 0xfa, 0xb5, 0x63, 0xf4, 0xfc, 0x3f, 0x26, 0x9b, 0xed,
	0x2f, 0x30, 0x08, 0x32, 0xd1, 0x12, 0x59, 0x64, 0x85, 0xa7, 0x11, 0x41, 0x7a, 0xa7, 0x3b, 0xb4,
	0xac, 0x72, 0xa6, 0x51, 0xa1, 0xfa, 0x5b, 0xae, 0xd3, 0x63, 0x6c, 0x72, 0x0d, 0x39, 0x70, 0x08,
};

static const uint8_t TEE_ATTR_DSA_PUBLIC_VALUE_3072_VALUE01[] = {
	0x45, 0x6a, 0x10, 0x5c, 0x71, 0x35, 0x66, 0x23, 0x48, 0x38, 0xbc, 0x07, 0x0b, 0x8a, 0x75, 0x1a, 0x0b, 0x57, 0x76, 0x7c, 0xb7, 0x5e, 0x99, 0x11,
	0x4a, 0x1a, 0x46, 0x64, 0x1e, 0x11, 0xda, 0x1f, 0xa9, 0xf2, 0x29, 0x14, 0xd8, 0x08, 0xad, 0x71, 0x48, 0x61, 0x2c, 0x1e, 0xa5, 0x5d, 0x25, 0x30,
	0x17, 0x81, 0xe9, 0xae, 0x0c, 0x9a, 0xe3, 0x6a, 0x69, 0xd8, 0x7b, 0xa0, 0x39, 0xec, 0x7c, 0xd8, 0x64, 0xc3, 0xad, 0x09, 0x48, 0x73, 0xe6, 0xe5,
	0x67, 0x09, 0xfd, 0x10, 0xd9, 0x66, 0x85, 0x3d, 0x61, 0x1b, 0x1c, 0xff, 0x15, 0xd3, 0x7f, 0xde, 0xe4, 0x24, 0x50, 0x6c, 0x18, 0x4d, 0x62, 0xc7,
	0x03, 0x33, 0x58, 0xbe, 0x78, 0xc2, 0x25, 0x09, 0x43, 0xb6, 0xf6, 0xd0, 0x43, 0xd6, 0x3b, 0x31, 0x7d, 0xe5, 0x6e, 0x5a, 0xd8, 0xd1, 0xfd, 0x97,
	0xdd, 0x35, 0x5a, 0xbe, 0x96, 0x45, 0x2f, 0x8e, 0x43, 0x54, 0x85, 0xfb, 0x3b, 0x90, 0x7b, 0x51, 0x90, 0x0a, 0xa3, 0xf2, 0x44, 0x18, 0xdf, 0x50,
	0xb4, 0xfc, 0xda, 0xfb, 0xf6, 0x13, 0x75, 0x48, 0xc3, 0x93, 0x73, 0xb8, 0xbc, 0x4b, 0xa3, 0xda, 0xbb, 0x47, 0x46, 0xeb, 0xd1, 0x7b, 0x87, 0xfc,
	0xd6, 0xa2, 0xf1, 0x97, 0xc1, 0x07, 0xb1, 0x8e, 0xc5, 0xb4, 0x65, 0xe6, 0xe4, 0xcb, 0x43, 0x0d, 0x9c, 0x0c, 0xe7, 0x8d, 0xa5, 0x98, 0x84, 0x41,
	0x05, 0x4a, 0x37, 0x07, 0x92, 0xb7, 0x30, 0xda, 0x9a, 0xba, 0x41, 0xa3, 0x16, 0x9a, 0xf2, 0x61, 0x76, 0xf7, 0x4e, 0x6f, 0x7c, 0x0c, 0x9c, 0x9b,
	0x55, 0xb6, 0x2b, 0xbe, 0x7c, 0xe3, 0x8d, 0x46, 0x95, 0xd4, 0x81, 0x57, 0xe6, 0x60, 0xc2, 0xac, 0xb6, 0x3f, 0x48, 0x2f, 0x55, 0x41, 0x81, 0x50,
	0xe5, 0xfe, 0xe4, 0x3a, 0xce, 0x84, 0xc5, 0x40, 0xc3, 0xba, 0x76, 0x62, 0xae, 0x80, 0x83, 0x5c, 0x1a, 0x2d, 0x51, 0x89, 0x0e, 0xa9, 0x6b, 0xa2,
	0x06, 0x42, 0x7c, 0x41, 0xef, 0x8c, 0x38, 0xaa, 0x07, 0xd2, 0xa3, 0x65, 0xe7, 0xe5, 0x83, 0x80, 0xd8, 0xf4, 0x78, 0x2e, 0x22, 0xac, 0x21, 0x01,
	0xaf, 0x73, 0x2e, 0xe2, 0x27, 0x58, 0x33, 0x7b, 0x25, 0x36, 0x37, 0x83, 0x8e, 0x16, 0xf5, 0x0f, 0x56, 0xd3, 0x13, 0xd0, 0x79, 0x81, 0x88, 0x0d,
	0x68, 0x55, 0x57, 0xf7, 0xd7, 0x9a, 0x6d, 0xb8, 0x23, 0xc6, 0x1f, 0x1b, 0xb3, 0xdb, 0xc5, 0xd5, 0x04, 0x21, 0xa4, 0x84, 0x3a, 0x6f, 0x29, 0x69,
	0x0e, 0x78, 0xaa, 0x0f, 0x0c, 0xff, 0x30, 0x42, 0x31, 0x81, 0x8b, 0x81, 0xfc, 0x4a, 0x24, 0x3f, 0xc0, 0x0f, 0x09, 0xa5, 0x4c, 0x46, 0x6d, 0x6a,
	0x8c, 0x73, 0xd3, 0x2a, 0x55, 0xe1, 0xab, 0xd5, 0xec, 0x8b, 0x4e, 0x1a, 0xfa, 0x32, 0xa7, 0x9b, 0x01, 0xdf, 0x85, 0xa8, 0x1f, 0x3f, 0x5c, 0xfe,
};

static const uint8_t TEE_ATTR_DSA_PUBLIC_VALUE_768_VALUE01[] = {
	0x52, 0x9d, 0xed, 0x98, 0xa2, 0x32, 0x09, 0x85, 0xfc, 0x84, 0xb6, 0x5a, 0x9d, 0xc8, 0xd4,
	0xfe, 0x41, 0xad, 0xa6, 0xe3, 0x59, 0x3d, 0x70, 0x4f, 0x08, 0x98, 0xc1, 0x4e, 0xc2, 0x46,
	0x34, 0xdd, 0xf5, 0xf1, 0xdb, 0x47, 0xcc, 0x49, 0x15, 0xfc, 0xe1, 0xe2, 0x67, 0x4d, 0x2e,
	0xcd, 0x98, 0xd5, 0x8b, 0x59, 0x8e, 0x8d, 0xdf, 0xaf, 0xf3, 0x0e, 0x88, 0x26, 0xf5, 0x0a,
	0xab, 0x40, 0x27, 0xb5, 0xaa, 0xb8, 0x87, 0xc1, 0x9a, 0xd9, 0x6d, 0x7e, 0x57, 0xde, 0x53,
	0x90, 0xad, 0x8e, 0x55, 0x57, 0xb4, 0x1a, 0x80, 0x19, 0xc9, 0x0d, 0x80, 0x60, 0x71, 0x79,
	0xb5, 0x4e, 0xb0, 0xad, 0x4d, 0x23,
};

static const uint8_t TEE_ATTR_DSA_SUBPRIME_160_VALUE01[] = {
	0x87, 0x44, 0xe4, 0xdd, 0xc6, 0xd0, 0x19, 0xa5, 0xea, 0xc2, 0xb1, 0x5a, 0x15, 0xd7,
	0xe1, 0xc7, 0xf6, 0x63, 0x35, 0xf7,
};

static const uint8_t TEE_ATTR_DSA_SUBPRIME_224_VALUE01[] = {
	0xea, 0x34, 0x7e, 0x90, 0xbe, 0x7c, 0x28, 0x75, 0xd1, 0xfe, 0x1d, 0xb6, 0x22, 0xb4,
	0x76, 0x38, 0x37, 0xc5, 0xe2, 0x7a, 0x60, 0x37, 0x31, 0x03, 0x48, 0xc1, 0xaa, 0x11,
};

static const uint8_t TEE_ATTR_DSA_SUBPRIME_256_VALUE01[] = {
	0x87, 0x6f, 0xa0, 0x9e, 0x1d, 0xc6, 0x2b, 0x23, 0x6c, 0xe1, 0xc3, 0x15, 0x5b, 0xa4, 0x8b, 0x0c,
	0xcf, 0xda, 0x29, 0xf3, 0xac, 0x5a, 0x97, 0xf7, 0xff, 0xa1, 0xbd, 0x87, 0xb6, 0x8d, 0x2a, 0x4b,
};

static const uint8_t TEE_ATTR_ECC_PRIVATE_VALUE_ECDH_P192_VALUE01[] = {
	0xf1, 0x7d, 0x3f, 0xea, 0x36, 0x7b, 0x74, 0xd3, 0x40, 0x85, 0x1c, 0xa4, 0x27, 0x0d, 0xcb, 0x24, 0xc2, 0x71, 0xf4, 0x45, 0xbe, 0xd9, 0xd5, 0x27,
};

static const uint8_t TEE_ATTR_ECC_PRIVATE_VALUE_ECDH_P224_VALUE01[] = {
	0x83, 0x46, 0xa6, 0x0f, 0xc6, 0xf2, 0x93, 0xca, 0x5a, 0x0d, 0x2a, 0xf6, 0x8b, 0xa7, 0x1d, 0x1d, 0xd3, 0x89, 0xe5, 0xe4, 0x08, 0x37, 0x94, 0x2d, 0xf3, 0xe4, 0x3c, 0xbd,
};

static const uint8_t TEE_ATTR_ECC_PRIVATE_VALUE_ECDH_P256_VALUE01[] = {
	0x7d, 0x7d, 0xc5, 0xf7, 0x1e, 0xb2, 0x9d, 0xda, 0xf8, 0x0d, 0x62, 0x14, 0x63, 0x2e, 0xea, 0xe0,
	0x3d, 0x90, 0x58, 0xaf, 0x1f, 0xb6, 0xd2, 0x2e, 0xd8, 0x0b, 0xad, 0xb6, 0x2b, 0xc1, 0xa5, 0x34,
};

static const uint8_t TEE_ATTR_ECC_PRIVATE_VALUE_ECDH_P384_VALUE01[] = {
	0x3c, 0xc3, 0x12, 0x2a, 0x68, 0xf0, 0xd9, 0x50, 0x27, 0xad, 0x38, 0xc0, 0x67, 0x91, 0x6b, 0xa0, 0xeb, 0x8c, 0x38, 0x89, 0x4d, 0x22, 0xe1, 0xb1,
	0x56, 0x18, 0xb6, 0x81, 0x8a, 0x66, 0x17, 0x74, 0xad, 0x46, 0x3b, 0x20, 0x5d, 0xa8, 0x8c, 0xf6, 0x99, 0xab, 0x4d, 0x43, 0xc9, 0xcf, 0x98, 0xa1,
};

static const uint8_t TEE_ATTR_ECC_PRIVATE_VALUE_ECDH_P521_VALUE01[] = {
	0x00, 0x00, 0x01, 0x7e, 0xec, 0xc0, 0x7a, 0xb4, 0xb3, 0x29, 0x06, 0x8f, 0xba, 0x65, 0xe5, 0x6a, 0x1f,
	0x88, 0x90, 0xaa, 0x93, 0x5e, 0x57, 0x13, 0x4a, 0xe0, 0xff, 0xcc, 0xe8, 0x02, 0x73, 0x51, 0x51, 0xf4,
	0xea, 0xc6, 0x56, 0x4f, 0x6e, 0xe9, 0x97, 0x4c, 0x5e, 0x68, 0x87, 0xa1, 0xfe, 0xfe, 0xe5, 0x74, 0x3a,
	0xe2, 0x24, 0x1b, 0xfe, 0xb9, 0x5d, 0x5c, 0xe3, 0x1d, 0xdc, 0xb6, 0xf9, 0xed, 0xb4, 0xd6, 0xfc, 0x47,
};

static const uint8_t TEE_ATTR_ECC_PRIVATE_VALUE_ECDSA_P192_VALUE01[] = {
	0xe1, 0x4f, 0x37, 0xb3, 0xd1, 0x37, 0x4f, 0xf8, 0xb0, 0x3f, 0x41, 0xb9, 0xb3, 0xfd, 0xd2, 0xf0, 0xeb, 0xcc, 0xf2, 0x75, 0xd6, 0x60, 0xd7, 0xf3,
};

static const uint8_t TEE_ATTR_ECC_PRIVATE_VALUE_ECDSA_P224_VALUE01[] = {
	0x97, 0xc4, 0xb7, 0x96, 0xe1, 0x63, 0x9d, 0xd1, 0x03, 0x5b, 0x70, 0x8f, 0xc0, 0x0d, 0xc7, 0xba, 0x16, 0x82, 0xce, 0xc4, 0x4a, 0x10, 0x02, 0xa1, 0xa8, 0x20, 0x61, 0x9f,
};

static const uint8_t TEE_ATTR_ECC_PRIVATE_VALUE_ECDSA_P256_VALUE01[] = {
	0xbe, 0x34, 0xba, 0xa8, 0xd0, 0x40, 0xa3, 0xb9, 0x91, 0xf9, 0x07, 0x5b, 0x56, 0xba, 0x29, 0x2f,
	0x75, 0x5b, 0x90, 0xe4, 0xb6, 0xdc, 0x10, 0xda, 0xd3, 0x67, 0x15, 0xc3, 0x3c, 0xfd, 0xac, 0x25,
};

static const uint8_t TEE_ATTR_ECC_PRIVATE_VALUE_ECDSA_P384_VALUE01[] = {
	0xa4, 0x92, 0xce, 0x8f, 0xa9, 0x00, 0x84, 0xc2, 0x27, 0xe1, 0xa3, 0x2f, 0x79, 0x74, 0xd3, 0x9e, 0x9f, 0xf6, 0x7a, 0x7e, 0x87, 0x05, 0xec, 0x34,
	0x19, 0xb3, 0x5f, 0xb6, 0x07, 0x58, 0x2b, 0xeb, 0xd4, 0x61, 0xe0, 0xb1, 0x52, 0x0a, 0xc7, 0x6e, 0xc2, 0xdd, 0x4e, 0x9b, 0x63, 0xeb, 0xae, 0x71,
};

static const uint8_t TEE_ATTR_ECC_PRIVATE_VALUE_ECDSA_P521_VALUE01[] = {
	0x01, 0xbd, 0x56, 0xbd, 0x10, 0x61, 0x18, 0xed, 0xa2, 0x46, 0x15, 0x5b, 0xd4, 0x3b, 0x42, 0xb8, 0xe1,
	0x3f, 0x0a, 0x6e, 0x25, 0xdd, 0x3b, 0xb3, 0x76, 0x02, 0x6f, 0xab, 0x4d, 0xc9, 0x2b, 0x61, 0x57, 0xbc,
	0x6d, 0xfe, 0xc2, 0xd1, 0x5d, 0xd3, 0xd0, 0xcf, 0x2a, 0x39, 0xaa, 0x68, 0x49, 0x40, 0x42, 0xaf, 0x48,
	0xba, 0x96, 0x01, 0x11, 0x8d, 0xa8, 0x2c, 0x6f, 0x21, 0x08, 0xa3, 0xa2, 0x03, 0xad, 0x74,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDH_P192_VALUE01[] = {
	0xb1, 0x50, 0x53, 0x40, 0x1f, 0x57, 0x28, 0x56, 0x37, 0xec, 0x32, 0x4c, 0x1c, 0xd2, 0x13, 0x9e, 0x3a, 0x67, 0xde, 0x37, 0x39, 0x23, 0x4b, 0x37,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDH_P192_VALUE02[] = {
	0x42, 0xea, 0x6d, 0xd9, 0x96, 0x9d, 0xd2, 0xa6, 0x1f, 0xea, 0x1a, 0xac, 0x7f, 0x8e, 0x98, 0xed,
	0xcc, 0x89, 0x6c, 0x6e, 0x55, 0x85, 0x7c, 0xc0,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDH_P224_VALUE01[] = {
	0x8d, 0xe2, 0xe2, 0x6a, 0xdf, 0x72, 0xc5, 0x82, 0xd6, 0x56, 0x8e, 0xf6, 0x38, 0xc4, 0xfd, 0x59, 0xb1, 0x8d, 0xa1, 0x71, 0xbd, 0xf5, 0x01, 0xf1, 0xd9, 0x29, 0xe0, 0x48,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDH_P224_VALUE02[] = {
	0xaf, 0x33, 0xcd, 0x06, 0x29, 0xbc, 0x7e, 0x99, 0x63, 0x20, 0xa3, 0xf4, 0x03, 0x68, 0xf7, 0x4d,
	0xe8, 0x70, 0x4f, 0xa3, 0x7b, 0x8f, 0xab, 0x69, 0xab, 0xaa, 0xe2, 0x80,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDH_P256_VALUE01[] = {
	0xea, 0xd2, 0x18, 0x59, 0x01, 0x19, 0xe8, 0x87, 0x6b, 0x29, 0x14, 0x6f, 0xf8, 0x9c, 0xa6, 0x17,
	0x70, 0xc4, 0xed, 0xbb, 0xf9, 0x7d, 0x38, 0xce, 0x38, 0x5e, 0xd2, 0x81, 0xd8, 0xa6, 0xb2, 0x30,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDH_P256_VALUE02[] = {
	0x70, 0x0c, 0x48, 0xf7, 0x7f, 0x56, 0x58, 0x4c, 0x5c, 0xc6, 0x32, 0xca, 0x65, 0x64, 0x0d, 0xb9,
	0x1b, 0x6b, 0xac, 0xce, 0x3a, 0x4d, 0xf6, 0xb4, 0x2c, 0xe7, 0xcc, 0x83, 0x88, 0x33, 0xd2, 0x87,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDH_P384_VALUE01[] = {
	0x98, 0x03, 0x80, 0x7f, 0x2f, 0x6d, 0x2f, 0xd9, 0x66, 0xcd, 0xd0, 0x29, 0x0b, 0xd4, 0x10, 0xc0, 0x19, 0x03, 0x52, 0xfb, 0xec, 0x7f, 0xf6, 0x24,
	0x7d, 0xe1, 0x30, 0x2d, 0xf8, 0x6f, 0x25, 0xd3, 0x4f, 0xe4, 0xa9, 0x7b, 0xef, 0x60, 0xcf, 0xf5, 0x48, 0x35, 0x5c, 0x01, 0x5d, 0xbb, 0x3e, 0x5f,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDH_P384_VALUE02[] = {
	0xa7, 0xc7, 0x6b, 0x97, 0x0c, 0x3b, 0x5f, 0xe8, 0xb0, 0x5d, 0x28, 0x38, 0xae, 0x04, 0xab, 0x47,
	0x69, 0x7b, 0x9e, 0xaf, 0x52, 0xe7, 0x64, 0x59, 0x2e, 0xfd, 0xa2, 0x7f, 0xe7, 0x51, 0x32, 0x72,
	0x73, 0x44, 0x66, 0xb4, 0x00, 0x09, 0x1a, 0xdb, 0xf2, 0xd6, 0x8c, 0x58, 0xe0, 0xc5, 0x00, 0x66,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDH_P521_VALUE01[] = {
	0x00, 0x00, 0x00, 0x60, 0x2f, 0x9d, 0x0c, 0xf9, 0xe5, 0x26, 0xb2, 0x9e, 0x22, 0x38, 0x1c, 0x20, 0x3c,
	0x48, 0xa8, 0x86, 0xc2, 0xb0, 0x67, 0x30, 0x33, 0x36, 0x63, 0x14, 0xf1, 0xff, 0xbc, 0xba, 0x24, 0x0b,
	0xa4, 0x2f, 0x4e, 0xf3, 0x8a, 0x76, 0x17, 0x46, 0x35, 0xf9, 0x1e, 0x6b, 0x4e, 0xd3, 0x42, 0x75, 0xeb,
	0x01, 0xc8, 0x46, 0x7d, 0x05, 0xca, 0x80, 0x31, 0x5b, 0xf1, 0xa7, 0xbb, 0xd9, 0x45, 0xf5, 0x50, 0xa5,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDH_P521_VALUE02[] = {
	0x00, 0x00, 0x00, 0x68, 0x5a, 0x48, 0xe8, 0x6c, 0x79, 0xf0, 0xf0, 0x87, 0x5f, 0x7b, 0xc1, 0x8d,
	0x25, 0xeb, 0x5f, 0xc8, 0xc0, 0xb0, 0x7e, 0x5d, 0xa4, 0xf4, 0x37, 0x0f, 0x3a, 0x94, 0x90, 0x34,
	0x08, 0x54, 0x33, 0x4b, 0x1e, 0x1b, 0x87, 0xfa, 0x39, 0x54, 0x64, 0xc6, 0x06, 0x26, 0x12, 0x4a,
	0x4e, 0x70, 0xd0, 0xf7, 0x85, 0x60, 0x1d, 0x37, 0xc0, 0x98, 0x70, 0xeb, 0xf1, 0x76, 0x66, 0x68,
	0x77, 0xa2, 0x04, 0x6d,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDSA_P192_VALUE01[] = {
	0x07, 0x00, 0x8e, 0xa4, 0x0b, 0x08, 0xdb, 0xe7, 0x64, 0x32, 0x09, 0x6e, 0x80, 0xa2, 0x49, 0x4c, 0x94, 0x98, 0x2d, 0x2d, 0x5b, 0xcf, 0x98, 0xe6,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDSA_P224_VALUE01[] = {
	0x8a, 0x4d, 0xca, 0x35, 0x13, 0x6c, 0x4b, 0x70, 0xe5, 0x88, 0xe2, 0x35, 0x54, 0x63, 0x7a, 0xe2, 0x51, 0x07, 0x7d, 0x13, 0x65, 0xa6, 0xba, 0x5d, 0xb9, 0x58, 0x5d, 0xe7,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDSA_P256_VALUE01[] = {
	0xfa, 0x27, 0x37, 0xfb, 0x93, 0x48, 0x8d, 0x19, 0xca, 0xef, 0x11, 0xae, 0x7f, 0xaf, 0x6b, 0x7f,
	0x4b, 0xcd, 0x67, 0xb2, 0x86, 0xe3, 0xfc, 0x54, 0xe8, 0xa6, 0x5c, 0x2b, 0x74, 0xae, 0xcc, 0xb0,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDSA_P384_VALUE01[] = {
	0xe5, 0x5f, 0xee, 0x6c, 0x49, 0xd8, 0xd5, 0x23, 0xf5, 0xce, 0x7b, 0xf9, 0xc0, 0x42, 0x5c, 0xe4, 0xff, 0x65, 0x07, 0x08, 0xb7, 0xde, 0x5c, 0xfb,
	0x09, 0x59, 0x01, 0x52, 0x39, 0x79, 0xa7, 0xf0, 0x42, 0x60, 0x2d, 0xb3, 0x08, 0x54, 0x73, 0x53, 0x69, 0x81, 0x3b, 0x5c, 0x3f, 0x5e, 0xf8, 0x68,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_X_ECDSA_P521_VALUE01[] = {
	0x01, 0x2f, 0xbc, 0xae, 0xff, 0xa6, 0xa5, 0x1f, 0x3e, 0xe4, 0xd3, 0xd2, 0xb5, 0x1c, 0x5d, 0xec, 0x6d,
	0x7c, 0x72, 0x6c, 0xa3, 0x53, 0xfc, 0x01, 0x4e, 0xa2, 0xbf, 0x7c, 0xfb, 0xb9, 0xb9, 0x10, 0xd3, 0x2c,
	0xbf, 0xa6, 0xa0, 0x0f, 0xe3, 0x9b, 0x6c, 0xdb, 0x89, 0x46, 0xf2, 0x27, 0x75, 0x39, 0x8b, 0x2e, 0x23,
	0x3c, 0x0c, 0xf1, 0x44, 0xd7, 0x8c, 0x8a, 0x77, 0x42, 0xb5, 0xc7, 0xa3, 0xbb, 0x5d, 0x23,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDH_P192_VALUE01[] = {
	0xf2, 0x69, 0xc1, 0x58, 0x63, 0x74, 0x82, 0xaa, 0xd6, 0x44, 0xcd, 0x69, 0x2d, 0xd1, 0xd3, 0xef, 0x2c, 0x8a, 0x7c, 0x49, 0xe3, 0x89, 0xf7, 0xf6,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDH_P192_VALUE02[] = {
	0xdf, 0xbe, 0x5d, 0x7c, 0x61, 0xfa, 0xc8, 0x8b, 0x11, 0x81, 0x1b, 0xde, 0x32, 0x8e, 0x8a, 0x0d,
	0x12, 0xbf, 0x01, 0xa9, 0xd2, 0x04, 0xb5, 0x23,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDH_P224_VALUE01[] = {
	0x4a, 0x68, 0xa1, 0xc2, 0xb0, 0xfb, 0x22, 0x93, 0x0d, 0x12, 0x05, 0x55, 0xc1, 0xec, 0xe5, 0x0e, 0xa9, 0x8d, 0xea, 0x84, 0x07, 0xf7, 0x1b, 0xe3, 0x6e, 0xfa, 0xc0, 0xde,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDH_P224_VALUE02[] = {
	0x88, 0x20, 0x92, 0xcc, 0xbb, 0xa7, 0x93, 0x0f, 0x41, 0x9a, 0x8a, 0x4f, 0x9b, 0xb1, 0x69, 0x78,
	0xbb, 0xc3, 0x83, 0x87, 0x29, 0x99, 0x25, 0x59, 0xa6, 0xf2, 0xe2, 0xd7,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDH_P256_VALUE01[] = {
	0x28, 0xaf, 0x61, 0x28, 0x1f, 0xd3, 0x5e, 0x2f, 0xa7, 0x00, 0x25, 0x23, 0xac, 0xc8, 0x5a, 0x42,
	0x9c, 0xb0, 0x6e, 0xe6, 0x64, 0x83, 0x25, 0x38, 0x9f, 0x59, 0xed, 0xfc, 0xe1, 0x40, 0x51, 0x41,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDH_P256_VALUE02[] = {
	0xdb, 0x71, 0xe5, 0x09, 0xe3, 0xfd, 0x9b, 0x06, 0x0d, 0xdb, 0x20, 0xba, 0x5c, 0x51, 0xdc, 0xc5,
	0x94, 0x8d, 0x46, 0xfb, 0xf6, 0x40, 0xdf, 0xe0, 0x44, 0x17, 0x82, 0xca, 0xb8, 0x5f, 0xa4, 0xac,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDH_P384_VALUE01[] = {
	0xba, 0x26, 0xca, 0x69, 0xec, 0x2f, 0x5b, 0x5d, 0x9d, 0xad, 0x20, 0xcc, 0x9d, 0xa7, 0x11, 0x38, 0x3a, 0x9d, 0xbe, 0x34, 0xea, 0x3f, 0xa5, 0xa2,
	0xaf, 0x75, 0xb4, 0x65, 0x02, 0x62, 0x9a, 0xd5, 0x4d, 0xd8, 0xb7, 0xd7, 0x3a, 0x8a, 0xbb, 0x06, 0xa3, 0xa3, 0xbe, 0x47, 0xd6, 0x50, 0xcc, 0x99,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDH_P384_VALUE02[] = {
	0xac, 0x68, 0xf1, 0x9f, 0x2e, 0x1c, 0xb8, 0x79, 0xae, 0xd4, 0x3a, 0x99, 0x69, 0xb9, 0x1a, 0x08,
	0x39, 0xc4, 0xc3, 0x8a, 0x49, 0x74, 0x9b, 0x66, 0x1e, 0xfe, 0xdf, 0x24, 0x34, 0x51, 0x91, 0x5e,
	0xd0, 0x90, 0x5a, 0x32, 0xb0, 0x60, 0x99, 0x2b, 0x46, 0x8c, 0x64, 0x76, 0x6f, 0xc8, 0x43, 0x7a,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDH_P521_VALUE01[] = {
	0x00, 0x00, 0x01, 0xb7, 0xc8, 0x5f, 0x26, 0xf5, 0xd4, 0xb2, 0xd7, 0x35, 0x5c, 0xf6, 0xb0, 0x21, 0x17,
	0x65, 0x99, 0x43, 0x76, 0x2b, 0x6d, 0x1d, 0xb5, 0xab, 0x4f, 0x1d, 0xbc, 0x44, 0xce, 0x7b, 0x29, 0x46,
	0xeb, 0x6c, 0x7d, 0xe3, 0x42, 0x96, 0x28, 0x93, 0xfd, 0x38, 0x7d, 0x1b, 0x73, 0xd7, 0xa8, 0x67, 0x2d,
	0x1f, 0x23, 0x69, 0x61, 0x17, 0x0b, 0x7e, 0xb3, 0x57, 0x99, 0x53, 0xee, 0x5c, 0xdc, 0x88, 0xcd, 0x2d,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDH_P521_VALUE02[] = {
	0x00, 0x00, 0x01, 0xba, 0x52, 0xc5, 0x6f, 0xc8, 0x77, 0x6d, 0x9e, 0x8f, 0x5d, 0xb4, 0xf0, 0xcc,
	0x27, 0x63, 0x6d, 0x0b, 0x74, 0x1b, 0xbe, 0x05, 0x40, 0x06, 0x97, 0x94, 0x2e, 0x80, 0xb7, 0x39,
	0x88, 0x4a, 0x83, 0xbd, 0xe9, 0x9e, 0x0f, 0x67, 0x16, 0x93, 0x9e, 0x63, 0x2b, 0xc8, 0x98, 0x6f,
	0xa1, 0x8d, 0xcc, 0xd4, 0x43, 0xa3, 0x48, 0xb6, 0xc3, 0xe5, 0x22, 0x49, 0x79, 0x55, 0xa4, 0xf3,
	0xc3, 0x02, 0xf6, 0x76,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDSA_P192_VALUE01[] = {
	0x76, 0xfa, 0xb6, 0x81, 0xd0, 0x0b, 0x41, 0x4e, 0xa6, 0x36, 0xba, 0x21, 0x5d, 0xe2, 0x6d, 0x98, 0xc4, 0x1b, 0xd7, 0xf2, 0xe4, 0xd6, 0x54, 0x77,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDSA_P224_VALUE01[] = {
	0xad, 0x3d, 0xee, 0x06, 0xde, 0x0b, 0xe8, 0x27, 0x9d, 0x4a, 0xf4, 0x35, 0xd7, 0x24, 0x5f, 0x14, 0xf3, 0xb4, 0xf8, 0x2e, 0xb5, 0x78, 0xe5, 0x19, 0xee, 0x00, 0x57, 0xb1,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDSA_P256_VALUE01[] = {
	0xd4, 0xcc, 0xd6, 0xda, 0xe6, 0x98, 0x20, 0x8a, 0xa8, 0xc3, 0xa6, 0xf3, 0x9e, 0x45, 0x51, 0x0d,
	0x03, 0xbe, 0x09, 0xb2, 0xf1, 0x24, 0xbf, 0xc0, 0x67, 0x85, 0x6c, 0x32, 0x4f, 0x9b, 0x4d, 0x09,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDSA_P384_VALUE01[] = {
	0x28, 0xf5, 0x9c, 0xc5, 0xdc, 0x50, 0x98, 0x92, 0xa9, 0x88, 0xd3, 0x8a, 0x8e, 0x25, 0x19, 0xde, 0x3d, 0x0c, 0x4f, 0xd0, 0xfb, 0xdb, 0x09, 0x93,
	0xe3, 0x8f, 0x18, 0x50, 0x6c, 0x17, 0x60, 0x6c, 0x5e, 0x24, 0x24, 0x92, 0x46, 0xf1, 0xce, 0x94, 0x98, 0x3a, 0x53, 0x61, 0xc5, 0xbe, 0x98, 0x3e,
};

static const uint8_t TEE_ATTR_ECC_PUBLIC_VALUE_Y_ECDSA_P521_VALUE01[] = {
	0x00, 0x9c, 0xde, 0xf8, 0x23, 0xdd, 0x7b, 0xf9, 0xa7, 0x9e, 0x8c, 0xce, 0xac, 0xd2, 0xe4, 0x52, 0x7c,
	0x23, 0x1d, 0x0a, 0xe5, 0x96, 0x7a, 0xf0, 0x95, 0x8e, 0x93, 0x1d, 0x7d, 0xdc, 0xcf, 0x28, 0x05, 0xa3,
	0xe6, 0x18, 0xdc, 0x30, 0x39, 0xfe, 0xc9, 0xfe, 0xbb, 0xd3, 0x30, 0x52, 0xfe, 0x4c, 0x0f, 0xee, 0x98,
	0xf0, 0x33, 0x10, 0x60, 0x64, 0x98, 0x2d, 0x88, 0xf4, 0xe0, 0x35, 0x49, 0xd4, 0xa6, 0x4d,
};

static const uint8_t TEE_ATTR_GENERIC_SECRET_2048_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
};

static const uint8_t TEE_ATTR_HMAC_MD5_256_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
};

static const uint8_t TEE_ATTR_HMAC_SHA1_256_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
};

static const uint8_t TEE_ATTR_HMAC_SHA224_256_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
};

static const uint8_t TEE_ATTR_HMAC_SHA256_512_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
};

static const uint8_t TEE_ATTR_HMAC_SHA384_512_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
};

static const uint8_t TEE_ATTR_HMAC_SHA512_512_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
};

static const uint8_t TEE_ATTR_RSA_COEFFICIENT_VALUE01[] = {
	0x94, 0x65, 0xe9, 0xd0, 0x98, 0xf8, 0x9c, 0x30, 0x25, 0xa8, 0xb1, 0x53, 0x78, 0x61,
	0x01, 0x1f, 0xde, 0x48, 0x91, 0x92, 0x90, 0x11, 0x6c, 0x96, 0x27, 0xce, 0xe1, 0x8f, 0x7b,
	0x37, 0x53, 0x25, 0x89, 0xac, 0x2c, 0xa8, 0x09, 0x2b, 0xff, 0x70, 0x42, 0x2a, 0xca, 0xfb,
	0x83, 0x68, 0xca, 0x8f, 0xaf, 0x1b, 0xcd, 0x11, 0x20, 0xfb, 0x64, 0x74, 0x5a, 0x35, 0xdf,
	0x7d, 0x79, 0xed, 0x29, 0xe5, 0xf7, 0xd9, 0xba, 0x5d, 0x02, 0x19, 0xb7, 0x88, 0x74, 0x33,
	0x86, 0xcd, 0x5d, 0xc5, 0xa2, 0x89, 0x36, 0xbe, 0x9e, 0xe5, 0x84, 0xc8, 0x08, 0xca, 0xbc,
	0x85, 0xd1, 0x95, 0x18, 0xba, 0x0f, 0xac, 0x4a, 0xa1, 0x03, 0x84, 0xe3, 0xd3, 0x2d, 0x38,
	0x81, 0xb3, 0x11, 0x27, 0x97, 0x1d, 0x7e, 0x84, 0xe8, 0xa4, 0xc3, 0xb2, 0x75, 0xdf, 0x96,
	0x91, 0xe0, 0x81, 0xa6, 0x57, 0xe9, 0x74, 0x82, 0x88,
};

static const uint8_t TEE_ATTR_RSA_EXPONENT1_VALUE01[] = {
	0x88, 0x14, 0x08, 0x30, 0x55, 0x6f, 0x85, 0x25, 0x7b, 0x61, 0xef, 0x47, 0xb5, 0xf6,
	0x69, 0x1a, 0xbc, 0x34, 0xcc, 0x80, 0x80, 0xf5, 0x35, 0x9b, 0x2e, 0x86, 0xb4, 0x3d, 0x3f,
	0x16, 0xb7, 0x18, 0x1f, 0x2f, 0xda, 0xd7, 0x27, 0x7c, 0x5e, 0x8d, 0x15, 0xde, 0x5e, 0x78,
	0xc0, 0xa6, 0x49, 0x94, 0x71, 0x4b, 0x97, 0x2e, 0x8c, 0xf4, 0x10, 0x66, 0x77, 0xbf, 0x78,
	0x31, 0xaf, 0xa7, 0xd0, 0x80, 0x3a, 0x73, 0x13, 0x56, 0xd4, 0x14, 0x04, 0x74, 0x46, 0x4e,
	0x91, 0x1d, 0xdc, 0x45, 0xa7, 0x7c, 0x00, 0x4b, 0x5d, 0x34, 0x70, 0xa0, 0x7f, 0x95, 0xb9,
	0xf2, 0x90, 0x76, 0x6b, 0x4d, 0x64, 0x1c, 0x94, 0x5b, 0x48, 0x2b, 0xdf, 0x37, 0x92, 0x2d,
	0x8d, 0x5e, 0x73, 0xf6, 0x89, 0x40, 0x2d, 0xed, 0x55, 0xd2, 0x40, 0x8f, 0x38, 0x82, 0x41,
	0x82, 0x64, 0xb2, 0xb4, 0xb0, 0xdf, 0xc7, 0x83, 0xc1,
};

static const uint8_t TEE_ATTR_RSA_EXPONENT2_VALUE01[] = {
	0x40, 0x26, 0x13, 0xa7, 0x0f, 0x28, 0x79, 0x92, 0xb7, 0x88, 0xca, 0x91, 0x0a, 0xa2, 0xe5,
	0xd1, 0x74, 0xa4, 0xbe, 0x5f, 0x91, 0x8b, 0xa8, 0xff, 0xb9, 0x3d, 0x01, 0xce, 0x5a, 0xc9,
	0xfd, 0xde, 0xb0, 0xc6, 0x1f, 0x52, 0x08, 0xd7, 0x46, 0x9e, 0x3e, 0x1e, 0x82, 0xa5, 0x77,
	0x30, 0x75, 0xb0, 0x16, 0xb1, 0x09, 0xbf, 0x3f, 0x35, 0x9f, 0x3e, 0xcd, 0x74, 0x02, 0x4c,
	0x99, 0x69, 0xa2, 0x02, 0x39, 0x7c, 0x7d, 0xd8, 0xce, 0x92, 0xe9, 0xa9, 0x33, 0x0d, 0xe5,
	0x3e, 0x05, 0x3d, 0xd0, 0x2c, 0xf3, 0x4a, 0xaa, 0xdb, 0xbe, 0xef, 0xd5, 0x9f, 0x2b, 0xec,
	0xbf, 0xea, 0xff, 0x75, 0x2d, 0x6d, 0x23, 0x12, 0x8d, 0x53, 0xe2, 0xca, 0x7f, 0xdb, 0x0d,
	0xbb, 0xc6, 0x5e, 0x16, 0xd5, 0xb1, 0x62, 0x8e, 0x1b, 0xbf, 0xbf, 0x0e, 0x2c, 0xb5, 0xcf,
	0x54, 0x55, 0x22, 0x21, 0xde, 0x7d, 0xba, 0xb1,
};

static const uint8_t TEE_ATTR_RSA_MODULUS_3072_VALUE01[] = {
	0xac, 0x6a, 0x77, 0xeb, 0xbf, 0x9c, 0x72, 0x5e, 0xc9, 0x73, 0x11, 0xf5, 0x4c, 0xd3, 0x5a, 0x4d, 0x98, 0xc4, 0x95, 0x82, 0x20, 0x13, 0x83, 0xcc,
	0x8c, 0xaf, 0x06, 0xde, 0x23, 0x3e, 0x8a, 0x64, 0x98, 0xcc, 0xa8, 0x1e, 0x57, 0x05, 0xff, 0x67, 0xc8, 0x78, 0x74, 0xcb, 0xa0, 0x07, 0x0c, 0x94,
	0xdc, 0xf7, 0x37, 0x0a, 0x13, 0xf4, 0x4c, 0x7b, 0xf6, 0xf3, 0x9e, 0x10, 0x39, 0xc0, 0xe7, 0x16, 0xf2, 0x1b, 0xb8, 0x1d, 0x23, 0x81, 0x15, 0xce,
	0x65, 0x19, 0x00, 0xc7, 0x62, 0x70, 0x86, 0xc6, 0xbc, 0x70, 0x47, 0xec, 0x8f, 0xc9, 0xf0, 0x27, 0x13, 0xdc, 0x7c, 0x6c, 0xb3, 0x53, 0x42, 0xcd,
	0xd3, 0xd0, 0x26, 0xb3, 0xe8, 0xe7, 0x35, 0x18, 0xe6, 0x57, 0xf2, 0xe1, 0x68, 0x35, 0x32, 0xa4, 0x8b, 0xfe, 0x3b, 0xbd, 0x55, 0x86, 0x95, 0x86,
	0x0c, 0x71, 0xfc, 0xd4, 0x4a, 0x27, 0x5e, 0x6d, 0x41, 0xd4, 0x02, 0xd5, 0xf0, 0x50, 0x40, 0x0a, 0x34, 0x02, 0xd3, 0xd5, 0xd4, 0xaa, 0xf9, 0x78,
	0x7d, 0xd7, 0x9a, 0x2d, 0x5c, 0x90, 0xa4, 0x3f, 0xd4, 0xcd, 0xf4, 0x3a, 0x48, 0xd0, 0xa5, 0x2b, 0x0b, 0x0d, 0xa5, 0xd3, 0xb1, 0xb5, 0x9c, 0xc2,
	0xab, 0xdd, 0xbc, 0xae, 0x0b, 0x8b, 0x1b, 0x02, 0xa2, 0xe2, 0xed, 0xba, 0xab, 0x93, 0x4e, 0x90, 0x30, 0x97, 0x60, 0xd6, 0x99, 0xec, 0xb9, 0x96,
	0x91, 0xd5, 0x1b, 0xbf, 0x06, 0x74, 0xa1, 0x45, 0xe6, 0xa3, 0x5b, 0x83, 0xa5, 0xad, 0x4a, 0xc3, 0x0d, 0xa4, 0x1b, 0x20, 0x52, 0x7d, 0x48, 0x1d,
	0x80, 0x3b, 0x2f, 0x77, 0xca, 0x0b, 0x1e, 0x18, 0x24, 0x33, 0x06, 0x87, 0xbb, 0x3c, 0x0a, 0x2a, 0x6c, 0x9e, 0xb7, 0x39, 0x5d, 0x26, 0x58, 0x5b,
	0x04, 0x8f, 0xc5, 0xde, 0x51, 0x8f, 0x3e, 0x5c, 0x2b, 0x96, 0x1f, 0xa9, 0x3d, 0x26, 0x5c, 0x45, 0x25, 0x9f, 0x2d, 0xb3, 0xbe, 0xff, 0xe5, 0xd1,
	0xf1, 0x2e, 0x0c, 0xc6, 0x74, 0x3f, 0x9b, 0x24, 0x39, 0x9b, 0x7c, 0x76, 0x4d, 0x88, 0xdb, 0x09, 0x30, 0x44, 0xbb, 0xad, 0x65, 0x82, 0x9b, 0xb6,
	0x1d, 0x21, 0xb1, 0x27, 0xb8, 0x7f, 0x90, 0x54, 0xee, 0xa0, 0x9c, 0x86, 0xb7, 0x56, 0x2d, 0x1c, 0x17, 0x3f, 0xa7, 0x3f, 0x72, 0x80, 0xc4, 0x9c,
	0x62, 0xdd, 0x0a, 0xa5, 0xcb, 0xfc, 0xf9, 0x47, 0xa5, 0xa5, 0x03, 0xb2, 0x96, 0x57, 0x6e, 0xef, 0xc0, 0xe6, 0x14, 0xcb, 0x59, 0x18, 0xb9, 0xf5,
	0xa6, 0xaa, 0x54, 0xb4, 0x8b, 0xf2, 0xe6, 0xbc, 0x87, 0x4c, 0x9d, 0x8c, 0x03, 0x1e, 0xe9, 0x81, 0x2f, 0x63, 0xd2, 0xfe, 0x88, 0x3f, 0x2f, 0x30,
	0x6a, 0xd1, 0xc5, 0x55, 0xd2, 0x1f, 0x29, 0x88, 0x2a, 0xf0, 0xb4, 0x73, 0x04, 0x60, 0xbb, 0x84, 0xab, 0xa7, 0x17, 0x2d, 0xbc, 0xe1, 0xa4, 0x49,
};

static const uint8_t TEE_ATTR_RSA_MODULUS_FOR_FUZZING_RSAN[] = {
	0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55,
	0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85,
	0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58,
	0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14,
	0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf,
	0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb,
};

static const uint8_t TEE_ATTR_RSA_MODULUS_VALUE01[] = {
	0xf0, 0x1a, 0x95, 0xcd, 0x5f, 0x9f, 0x1c, 0xbc, 0x5c, 0x2e, 0xc8, 0x00, 0x3b, 0xfa,
	0xe0, 0xd5, 0x72, 0xea, 0xfc, 0x9e, 0x74, 0xe1, 0x02, 0x66, 0xa8, 0x13, 0x3f, 0x0c, 0xe6,
	0x24, 0xcb, 0x1c, 0xa5, 0xdf, 0x64, 0xfb, 0x06, 0xd7, 0x13, 0xce, 0xaa, 0x6c, 0xee, 0x16,
	0x7b, 0xf8, 0x92, 0xaf, 0xc4, 0x5b, 0x46, 0x18, 0xc6, 0x30, 0xb6, 0x04, 0x1c, 0x3a, 0x2e,
	0xd7, 0xca, 0xb8, 0xb5, 0x00, 0x78, 0x89, 0xa0, 0x69, 0x37, 0x84, 0x59, 0x99, 0x0c, 0x2f,
	0x00, 0xe5, 0x3b, 0xe1, 0x18, 0xe0, 0xb9, 0x2e, 0x77, 0x1d, 0x32, 0x7e, 0x5f, 0xf4, 0x18,
	0xf3, 0x9f, 0x58, 0xc6, 0x83, 0xe2, 0x7a, 0xcb, 0x89, 0x18, 0xc2, 0x09, 0x84, 0x7e, 0x9d,
	0x96, 0xe0, 0xb9, 0x49, 0x75, 0xef, 0xcf, 0xff, 0xf0, 0xb6, 0x18, 0xd3, 0x7a, 0xc1, 0x6f,
	0x0c, 0x55, 0x33, 0xbe, 0x9d, 0x63, 0x06, 0xd6, 0x9f, 0xc1, 0xa5, 0xe9, 0xbd, 0xb1, 0xb2,
	0x5d, 0x5c, 0xf9, 0xab, 0xa9, 0xb5, 0x6a, 0x4e, 0xa4, 0xfa, 0x44, 0x32, 0xd6, 0x71, 0x2e,
	0x5f, 0xa6, 0x25, 0xf8, 0x40, 0x24, 0xc4, 0x5b, 0x61, 0x55, 0x1b, 0xac, 0xa3, 0x0a, 0x11,
	0x8e, 0x65, 0x20, 0xda, 0x2c, 0x0d, 0xdf, 0xdb, 0x47, 0x6b, 0x61, 0x18, 0x4d, 0xfe, 0xfd,
	0x2a, 0x7e, 0x77, 0x40, 0x44, 0x43, 0xc6, 0x33, 0x6c, 0xe5, 0x1b, 0x8d, 0x80, 0xf9, 0x97,
	0xa2, 0xe4, 0xb9, 0x34, 0x3e, 0x28, 0x94, 0x9f, 0xbd, 0xa8, 0x2b, 0x0a, 0x4d, 0x1a, 0xa8,
	0x06, 0xe5, 0x99, 0x4e, 0xb9, 0x13, 0x45, 0xc8, 0xf6, 0x0f, 0xd0, 0x4d, 0xbf, 0xe7, 0x8f,
	0xed, 0xca, 0x8e, 0xf8, 0x8d, 0x87, 0x5f, 0xd4, 0xb4, 0x1a, 0x2c, 0xc9, 0xa7, 0x67, 0x7e,
	0xb2, 0x1b, 0xc1, 0xce, 0xb6, 0x83, 0x7c, 0xce, 0xb4, 0x3d, 0x85, 0xc7, 0x53, 0x30, 0x7c,
	0xfe, 0x85,
};

static const uint8_t TEE_ATTR_RSA_OAEP_LABEL_VALUE01[] = { 1 };

static const uint8_t TEE_ATTR_RSA_PRIME1_VALUE01[] = {
	0xfe, 0x56, 0xe9, 0x8b, 0x84, 0xa4, 0x6f, 0x98, 0x45, 0xad, 0x05, 0xbc, 0x67, 0x04,
	0x5f, 0xae, 0x08, 0xdf, 0xe1, 0x8c, 0xcd, 0x49, 0x1d, 0x9d, 0x8e, 0x1e, 0x82, 0x47, 0x0c,
	0x3c, 0x70, 0x40, 0x2d, 0x61, 0xe7, 0xde, 0xd7, 0x6e, 0xb9, 0xeb, 0xf0, 0xa9, 0xff, 0x59,
	0xe1, 0xf8, 0xb7, 0x20, 0x9c, 0xc4, 0x13, 0xd0, 0xd6, 0x41, 0xfb, 0x2b, 0xb0, 0x9b, 0xf2,
	0x93, 0x20, 0x9a, 0x32, 0x67, 0xed, 0xaf, 0x25, 0xdc, 0xa8, 0xc2, 0x8f, 0x28, 0xab, 0xf8,
	0xed, 0xb1, 0x3f, 0x65, 0xd4, 0xe8, 0x48, 0xf2, 0x41, 0x88, 0x21, 0xcb, 0xab, 0x1e, 0xf7,
	0x97, 0x68, 0xe8, 0x32, 0x7d, 0xec, 0x18, 0xf1, 0x83, 0x91, 0x13, 0xf8, 0x8c, 0x89, 0xe1,
	0x0a, 0x6c, 0xff, 0x82, 0xc1, 0x07, 0x00, 0xbd, 0xbc, 0x20, 0xa3, 0x51, 0x6d, 0x86, 0x5a,
	0x19, 0x29, 0x19, 0x02, 0x2f, 0xed, 0x41, 0x08, 0x89,
};

static const uint8_t TEE_ATTR_RSA_PRIME2_VALUE01[] = {
	0xf1, 0xab, 0xe1, 0x59, 0x38, 0x71, 0x9e, 0x55, 0x22, 0x40, 0x6d, 0xa1, 0xc6, 0xb9,
	0x6d, 0xba, 0x57, 0x53, 0xec, 0xfd, 0xd2, 0x22, 0x2d, 0xba, 0x74, 0x9e, 0xdc, 0x33, 0x83,
	0xcd, 0x44, 0xd2, 0x7a, 0x63, 0xf3, 0xe0, 0x55, 0x5f, 0x4b, 0x03, 0xe5, 0x58, 0x7b, 0xe8,
	0x99, 0x5e, 0x8c, 0x75, 0x34, 0x3a, 0xa2, 0x96, 0x3c, 0x3b, 0x13, 0xaa, 0xb7, 0x58, 0x1d,
	0xad, 0x2c, 0x88, 0xbb, 0x99, 0x0a, 0x0b, 0xff, 0x9b, 0x68, 0x4d, 0x96, 0x1a, 0xe9, 0x52,
	0xf1, 0xa2, 0xcb, 0xb9, 0xe9, 0xe8, 0x63, 0x3d, 0x40, 0x14, 0x64, 0xb5, 0xd6, 0xe5, 0xf2,
	0x2a, 0x70, 0x4f, 0x1a, 0xab, 0x03, 0x63, 0xaa, 0x0d, 0xc7, 0xb3, 0xf3, 0x06, 0xb0, 0xca,
	0xb1, 0x48, 0x0d, 0x18, 0x63, 0x2e, 0xcc, 0xd9, 0xca, 0x2c, 0x5a, 0x1a, 0x75, 0x50, 0x0e,
	0x11, 0xb0, 0xd5, 0xa7, 0x74, 0x25, 0xe7, 0x0f, 0x1d,
};

static const uint8_t TEE_ATTR_RSA_PRIVATE_EXPONENT_3072_VALUE01[] = {
	0x09, 0x83, 0x77, 0x7b, 0xbe, 0x9c, 0x98, 0xdd, 0xdf, 0x0e, 0xa0, 0xde, 0x97, 0xa1, 0x3e, 0x3e, 0xd1, 0x86, 0x3a, 0x7b, 0x8b, 0xeb, 0x62, 0xd7,
	0xa3, 0x92, 0xfc, 0x17, 0xe8, 0x91, 0xa3, 0xe8, 0x25, 0x12, 0x3e, 0x71, 0xba, 0xf0, 0x2c, 0xa4, 0xef, 0xc4, 0xd8, 0xdc, 0xc7, 0x64, 0x15, 0xfb,
	0xc9, 0x9c, 0x13, 0x8f, 0xa3, 0x7c, 0x6c, 0x41, 0x4d, 0x36, 0x5d, 0x2c, 0x59, 0x54, 0x54, 0x8f, 0x6f, 0x88, 0xaf, 0xa3, 0x24, 0x48, 0x10, 0x09,
	0x0f, 0x63, 0x69, 0x11, 0x69, 0x46, 0x67, 0xff, 0x15, 0x52, 0x81, 0xb8, 0x31, 0x1a, 0x50, 0x28, 0xdd, 0x88, 0x75, 0xfb, 0x17, 0xad, 0x9d, 0xe0,
	0x58, 0x47, 0x0a, 0xfc, 0x54, 0xa9, 0xef, 0xf6, 0x22, 0xd0, 0xf8, 0x0a, 0x04, 0xa6, 0xea, 0xe7, 0x8a, 0x15, 0x36, 0xcd, 0x2c, 0xb5, 0xb1, 0x77,
	0xde, 0x39, 0xc0, 0x35, 0xfd, 0x2b, 0xfd, 0x0a, 0xf9, 0x1b, 0x65, 0xca, 0x32, 0x9d, 0x27, 0x9c, 0xfc, 0xcb, 0xca, 0x6d, 0x74, 0x97, 0x3c, 0x5a,
	0xb9, 0x4b, 0x35, 0xc0, 0x40, 0xaa, 0xe6, 0x1c, 0x01, 0x69, 0x2c, 0x95, 0xfa, 0x00, 0xd0, 0x2c, 0x2f, 0xc7, 0x2c, 0xf5, 0xee, 0x48, 0x50, 0x79,
	0x62, 0xbb, 0xfc, 0xd6, 0xc7, 0xe5, 0xc7, 0x78, 0xed, 0x91, 0xfd, 0xd8, 0x0f, 0x52, 0x90, 0x0d, 0x4e, 0x78, 0x66, 0x1a, 0x34, 0x3a, 0x20, 0x67,
	0xb6, 0xf9, 0xc7, 0x96, 0x43, 0xad, 0x28, 0x56, 0xd4, 0xc0, 0xd4, 0x9c, 0x19, 0x5a, 0x03, 0xef, 0x57, 0x72, 0x92, 0x34, 0xac, 0xd9, 0x51, 0x8d,
	0x3b, 0xef, 0xfa, 0x23, 0x04, 0xe7, 0xdc, 0xde, 0x0f, 0xdd, 0x8a, 0xd2, 0xc3, 0xd0, 0x92, 0x87, 0xb1, 0x0c, 0x32, 0x66, 0x27, 0x14, 0x07, 0x7c,
	0x19, 0xf8, 0x8c, 0x04, 0x77, 0x9d, 0x92, 0x6b, 0x78, 0xeb, 0x5a, 0xe2, 0xb3, 0x05, 0x06, 0x34, 0x49, 0x2c, 0x7d, 0x78, 0xfa, 0x66, 0xb7, 0xdd,
	0x73, 0x1d, 0xd4, 0x5c, 0xa9, 0x32, 0x37, 0x07, 0xe5, 0xc4, 0xf4, 0x1c, 0x97, 0x1c, 0x76, 0xe5, 0x3c, 0x04, 0x40, 0x3c, 0x22, 0x54, 0xdd, 0xa6,
	0x35, 0xcb, 0xb3, 0x50, 0x5a, 0x6c, 0xb5, 0x89, 0x33, 0xa6, 0x58, 0x70, 0x0a, 0x85, 0xd5, 0xb7, 0xa2, 0x50, 0x98, 0x68, 0x0c, 0xf3, 0xf4, 0xc0,
	0x20, 0x5b, 0x09, 0x95, 0x7e, 0x0f, 0xae, 0x8c, 0xf8, 0x19, 0x23, 0x0e, 0x61, 0x79, 0x96, 0xfd, 0x80, 0xed, 0x6d, 0x9a, 0xe5, 0x65, 0x64, 0x5b,
	0x29, 0x3f, 0x12, 0xaf, 0xa4, 0xc4, 0x07, 0x6d, 0x2e, 0xa6, 0x5b, 0xb6, 0x9a, 0xf5, 0x05, 0x8c, 0xeb, 0x5c, 0x4b, 0x3c, 0x68, 0x4b, 0xe0, 0x8a,
	0xcb, 0x60, 0x21, 0x47, 0x2b, 0xd9, 0x3a, 0x37, 0x27, 0x5a, 0x1c, 0x20, 0xfc, 0xdf, 0x05, 0xb2, 0x77, 0x56, 0xba, 0x10, 0x15, 0xd3, 0x84, 0xa3,
};

static const uint8_t TEE_ATTR_RSA_PRIVATE_EXPONENT_FOR_FUZZING_RSAD[] = {
	0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf,
	0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b,
	0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26,
	0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf,
	0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd,
	0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1,
};

static const uint8_t TEE_ATTR_RSA_PRIVATE_EXPONENT_VALUE01[] = {
	0xa5, 0x0d, 0xe1, 0x84, 0xf9, 0x02, 0xec, 0x42, 0x20, 0x2c, 0x98, 0x98, 0x70, 0xa3,
	0x1a, 0x04, 0x21, 0xa7, 0xa0, 0x59, 0x5d, 0x87, 0x80, 0x9b, 0x09, 0x57, 0x91, 0xb4, 0x50,
	0x51, 0x62, 0xbf, 0x22, 0xd7, 0xdb, 0x17, 0x25, 0xb0, 0x9c, 0x91, 0x29, 0x5f, 0x10, 0x9c,
	0xac, 0x44, 0x48, 0xb2, 0x43, 0x8d, 0x6b, 0x36, 0x84, 0xa7, 0xdf, 0xb8, 0x1b, 0x9f, 0x73,
	0xac, 0x2c, 0x53, 0xa5, 0x39, 0xd9, 0xa2, 0xe2, 0x7e, 0xf2, 0x07, 0x2d, 0x80, 0xa4, 0x7b,
	0x7b, 0x66, 0x1a, 0x2f, 0xb7, 0x66, 0x64, 0x66, 0xa8, 0xc3, 0x8d, 0x7e, 0x8a, 0x7f, 0xc6,
	0xd7, 0x52, 0xe7, 0x38, 0x30, 0x59, 0x74, 0x88, 0x8e, 0x8a, 0x52, 0x79, 0x30, 0x77, 0xc9,
	0xe5, 0x7a, 0x3e, 0x65, 0x5d, 0x89, 0xa9, 0xb7, 0x0b, 0xc6, 0x62, 0x72, 0x9e, 0xa4, 0x72,
	0xae, 0x4b, 0xb3, 0xf2, 0x89, 0x47, 0x15, 0xe0, 0x5b, 0x45, 0x4d, 0x99, 0x5b, 0x13, 0x6c,
	0x90, 0xbe, 0xe5, 0xb5, 0x98, 0xad, 0x87, 0x99, 0x1a, 0x57, 0xd4, 0x1f, 0xf1, 0x52, 0x71,
	0x5b, 0x51, 0x40, 0xdc, 0x51, 0x35, 0xf6, 0x6c, 0xae, 0xa3, 0xf9, 0x0f, 0x3a, 0xed, 0x28,
	0xfc, 0xa5, 0x60, 0x2f, 0x4b, 0x4f, 0x31, 0xac, 0x48, 0x3e, 0x5b, 0xba, 0xe4, 0x2b, 0x58,
	0x79, 0xe6, 0xb4, 0x6b, 0x5e, 0x56, 0x0a, 0xb2, 0xdb, 0x68, 0xed, 0x24, 0xd8, 0x5e, 0x6f,
	0x30, 0x59, 0x8d, 0x8c, 0xa3, 0x00, 0x68, 0xf5, 0x42, 0x95, 0x1a, 0x0b, 0xa8, 0x1c, 0xfb,
	0xdf, 0x29, 0x81, 0x10, 0x32, 0x02, 0xcc, 0x51, 0xa4, 0x17, 0x14, 0x3e, 0xef, 0x89, 0x41,
	0xde, 0xf8, 0x2d, 0x64, 0x69, 0x30, 0xe8, 0x8a, 0xad, 0x96, 0xf6, 0xf4, 0x82, 0x83, 0x9a,
	0x77, 0xe7, 0xde, 0x12, 0x31, 0xf7, 0x15, 0xec, 0xce, 0xed, 0x83, 0x68, 0x88, 0x84, 0xe5,
	0x64, 0x81,
};

static const uint8_t TEE_ATTR_RSA_PUBLIC_EXPONENT_3072_VALUE01[] = {
	0x53, 0x5c, 0x97,
};

static const uint8_t TEE_ATTR_RSA_PUBLIC_EXPONENT_FOR_FUZZING_RSAE[] = {
	0x01, 0x00, 0x01,
};

static const uint8_t TEE_ATTR_RSA_PUBLIC_EXPONENT_VALUE_GEN_OUT_OF_RANGE_SUP[] = {
	0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};

static const uint8_t TEE_ATTR_SECRET_VALUE_1024_SHARED_SECRET_DH_VALUE01[] = {
	0x4e, 0x6a, 0xcf, 0xfd, 0x7d, 0x14, 0x27, 0x65, 0xeb, 0xf4, 0xc7, 0x12, 0x41, 0x4f, 0xe4, 0xb6,
	0xab, 0x95, 0x7f, 0x4c, 0xb4, 0x66, 0xb4, 0x66, 0x01, 0x28, 0x9b, 0xb8, 0x20, 0x60, 0x42, 0x82,
	0x72, 0x84, 0x2e, 0xe2, 0x8f, 0x11, 0x3c, 0xd1, 0x1f, 0x39, 0x43, 0x1c, 0xbf, 0xfd, 0x82, 0x32,
	0x54, 0xce, 0x47, 0x2e, 0x21, 0x05, 0xe4, 0x9b, 0x3d, 0x7f, 0x11, 0x3b, 0x82, 0x50, 0x76, 0xe6,
	0x26, 0x45, 0x85, 0x80, 0x7b, 0xc4, 0x64, 0x54, 0x66, 0x5f, 0x27, 0xc5, 0xe4, 0xe1, 0xa4, 0xbd,
	0x03, 0x47, 0x04, 0x86, 0x32, 0x29, 0x81, 0xfd, 0xc8, 0x94, 0xcc, 0xa1, 0xe2, 0x93, 0x09, 0x87,
	0xc9, 0x2c, 0x15, 0xa3, 0x8b, 0xc4, 0x2e, 0xb3, 0x88, 0x10, 0xe8, 0x67, 0xc4, 0x43, 0x2f, 0x07,
	0x25, 0x9e, 0xc0, 0x0c, 0xdb, 0xbb, 0x0f, 0xb9, 0x9e, 0x17, 0x27, 0xc7, 0x06, 0xda, 0x58, 0xdd,
};

static const uint8_t TEE_ATTR_SECRET_VALUE_192_SHARED_SECRET_ECDH_VALUE01[] = {
	0x80, 0x3d, 0x8a, 0xb2, 0xe5, 0xb6, 0xe6, 0xfc, 0xa7, 0x15, 0x73, 0x7c, 0x3a, 0x82, 0xf7, 0xce,
	0x3c, 0x78, 0x31, 0x24, 0xf6, 0xd5, 0x1c, 0xd0,
};

static const uint8_t TEE_ATTR_SECRET_VALUE_224_SHARED_SECRET_ECDH_VALUE01[] = {
	0x7d, 0x96, 0xf9, 0xa3, 0xbd, 0x3c, 0x05, 0xcf, 0x5c, 0xc3, 0x7f, 0xeb, 0x8b, 0x9d, 0x52, 0x09,
	0xd5, 0xc2, 0x59, 0x74, 0x64, 0xde, 0xc3, 0xe9, 0x98, 0x37, 0x43, 0xe8,
};

static const uint8_t TEE_ATTR_SECRET_VALUE_256_SHARED_SECRET_ECDH_VALUE01[] = {
	0x46, 0xfc, 0x62, 0x10, 0x64, 0x20, 0xff, 0x01, 0x2e, 0x54, 0xa4, 0x34, 0xfb, 0xdd, 0x2d, 0x25,
	0xcc, 0xc5, 0x85, 0x20, 0x60, 0x56, 0x1e, 0x68, 0x04, 0x0d, 0xd7, 0x77, 0x89, 0x97, 0xbd, 0x7b,
};

static const uint8_t TEE_ATTR_SECRET_VALUE_384_SHARED_SECRET_ECDH_VALUE01[] = {
	0x5f, 0x9d, 0x29, 0xdc, 0x5e, 0x31, 0xa1, 0x63, 0x06, 0x03, 0x56, 0x21, 0x36, 0x69, 0xc8, 0xce,
	0x13, 0x2e, 0x22, 0xf5, 0x7c, 0x9a, 0x04, 0xf4, 0x0b, 0xa7, 0xfc, 0xea, 0xd4, 0x93, 0xb4, 0x57,
	0xe5, 0x62, 0x1e, 0x76, 0x6c, 0x40, 0xa2, 0xe3, 0xd4, 0xd6, 0xa0, 0x4b, 0x25, 0xe5, 0x33, 0xf1,
};

static const uint8_t TEE_ATTR_SECRET_VALUE_4096_VALUE01[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
};

static const uint8_t TEE_ATTR_SECRET_VALUE_521_SHARED_SECRET_ECDH_VALUE01[] = {
	0x00, 0x5f, 0xc7, 0x04, 0x77, 0xc3, 0xe6, 0x3b, 0xc3, 0x95, 0x4b, 0xd0, 0xdf, 0x3e, 0xa0, 0xd1,
	0xf4, 0x1e, 0xe2, 0x17, 0x46, 0xed, 0x95, 0xfc, 0x5e, 0x1f, 0xdf, 0x90, 0x93, 0x0d, 0x5e, 0x13,
	0x66, 0x72, 0xd7, 0x2c, 0xc7, 0x70, 0x74, 0x2d, 0x17, 0x11, 0xc3, 0xc3, 0xa4, 0xc3, 0x34, 0xa0,
	0xad, 0x97, 0x59, 0x43, 0x6a, 0x4d, 0x3c, 0x5b, 0xf6, 0xe7, 0x4b, 0x95, 0x78, 0xfa, 0xc1, 0x48,
	0xc8, 0x31,
};

static const uint32_t TEE_ATTR_VALUE_ZERO;

/*
 * Values are 32 bits, while this is 64 so it can never clash with a real
 * value.
 */
#define TEE_ATTR_VALUE_NONE 0xffffffffffffffff

static uint32_t TEE_ATTR_RSA_PUBLIC_EXPONENT_VALUE01[] = { 0x10001 };

static const uint8_t BUFFER01[] = {
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
	0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
};

static const uint8_t INITIAL_DATA[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
};

static const uint8_t SINGLE_BYTE[] = { 0 };

/** ALL_TEEC_UUID
 *
 * These constants are the UUID of existing
 * Trusted Applications
 */
/* "SMARTCSLTDATAST1" */
static TEEC_UUID UUID_TTA_testingInternalAPI_dataStorage = {
	0x534D4152, 0x5443, 0x534C,
	{ 0x54, 0x44, 0x41, 0x54, 0x41, 0x53, 0x54, 0x31 }
};

static TEEC_Result Invoke_ReadObjectData(
	ADBG_Case_t *c, TEEC_Session *sess, uint32_t cmdId,
	uint32_t obj_handle, uint32_t buffer, uint32_t buffer_size)
{
	TEEC_Result res = TEE_ERROR_NOT_SUPPORTED;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org;

	ALLOCATE_SHARED_MEMORY(sess->imp.ctx, SHARE_MEM01, buffer_size,
			       TEEC_MEM_OUTPUT, mem01_exit)

	op.params[0].value.a = obj_handle;
	op.params[0].value.b = buffer;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(1, 0, SHARE_MEM01,
					      SHARE_MEM01->size)

	op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT,
					 TEEC_MEMREF_PARTIAL_OUTPUT,
					 TEEC_NONE, TEEC_NONE);

	free(saved_obj_data);
	saved_obj_data = NULL;
	saved_obj_data_size = 0;

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	if (!res) {
		size_t sz = op.params[1].memref.size;

		saved_obj_data = malloc(sz);
		memcpy(saved_obj_data, SHARE_MEM01->buffer, sz);
		saved_obj_data_size = sz;
	}

	TEEC_ReleaseSharedMemory(SHARE_MEM01);
mem01_exit:
	return res;
}

#define Check_ReadObjectData_DataRead(c, data, data_size) \
	ADBG_EXPECT_BUFFER(c, data, data_size, saved_obj_data, \
			   saved_obj_data_size)

#define Check_ReadObjectData_AfterWrite(c, data, data_size) \
	ADBG_EXPECT_BUFFER(c, data, data_size, saved_obj_data, \
			   saved_obj_data_size)

static TEEC_Result Invoke_RenamePersistentObject(ADBG_Case_t *c,
						 TEEC_Session *sess,
						 uint32_t cmdId,
						 uint32_t obj_handle,
						 const char *new_obj_id,
						 bool use_parameter_buffer)
{
	TEEC_Result res = TEE_ERROR_NOT_SUPPORTED;
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	size_t obj_id_len = 0;
	uint32_t org = 0;

	if (new_obj_id)
		obj_id_len = strlen(new_obj_id);
	ALLOCATE_AND_FILL_SHARED_MEMORY(sess->imp.ctx, SHARE_MEM01, obj_id_len,
					TEEC_MEM_INPUT, obj_id_len, new_obj_id,
					mem01_exit);

	op.params[0].value.a = obj_handle;
	op.params[1].value.a = use_parameter_buffer;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(2, 0, SHARE_MEM01,
					      SHARE_MEM01->size)

	op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, TEEC_VALUE_INPUT,
					 TEEC_MEMREF_PARTIAL_INPUT, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmdId, &op, &org);

	TEEC_ReleaseSharedMemory(SHARE_MEM01);
mem01_exit:
	return res;
}

static TEEC_Result Invoke_AllocateTransientObject(ADBG_Case_t *c,
						  TEEC_Session *sess,
						  uint32_t cmd,
						  uint32_t obj_type,
						  uint32_t obj_size,
						  uint32_t obj_handle)
{
	return Invoke_Simple_Function_v2(c, sess, cmd, obj_handle, 0, obj_type,
					 obj_size);
}

static TEEC_Result Invoke_GetObjectInfo1(ADBG_Case_t *c,
					 TEEC_Session *sess, uint32_t cmd,
					 uint32_t obj_handle, uint32_t obj_info)
{
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	TEEC_Result res;
	uint32_t org;

	op.params[0].value.a = obj_handle;
	op.params[0].value.b = obj_info;

	op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INOUT, TEEC_VALUE_OUTPUT,
					 TEEC_VALUE_OUTPUT, TEEC_VALUE_OUTPUT);

	memset(saved_obj_info, 0, sizeof(saved_obj_info[0]));

	res = TEEC_InvokeCommand(sess, cmd, &op, &org);
	if (!res) {
		saved_obj_info[0].obj_type = op.params[0].value.b;
		saved_obj_info[0].obj_size = op.params[1].value.a;
		saved_obj_info[0].max_obj_size = op.params[1].value.b;
		saved_obj_info[0].obj_usage = op.params[2].value.a;
		saved_obj_info[0].data_size = op.params[2].value.b;
		saved_obj_info[0].data_pos = op.params[3].value.a;
		saved_obj_info[0].handle_flags = op.params[3].value.b;
	}

	return res;
}

static TEEC_Result Invoke_GetObjectInfo(ADBG_Case_t *c, TEEC_Session *sess,
					uint32_t cmd, uint32_t obj_handle,
					uint32_t obj_info)
{
	return Invoke_GetObjectInfo1(c, sess, cmd, obj_handle, obj_info);
}

#define check_saved_obj_info(c, n, IN_ObjectType, IN_KeySize, IN_MaxKeySize, \
			     IN_ObjectUsage, IN_DataSize, IN_DataPosition, \
			     IN_HandleFlags_Data) \
	do { \
		if (ADBG_EXPECT_COMPARE_UNSIGNED(c, n, <, \
						 MAX_NUM_SAVED_OBJ_INFO)) { \
			ADBG_EXPECT(c, IN_ObjectType, \
				    saved_obj_info[n].obj_type); \
			ADBG_EXPECT(c, IN_KeySize, \
				    saved_obj_info[n].obj_size); \
			ADBG_EXPECT(c, IN_MaxKeySize, \
				    saved_obj_info[n].max_obj_size); \
			ADBG_EXPECT(c, IN_ObjectUsage, \
				    saved_obj_info[n].obj_usage); \
			ADBG_EXPECT(c, IN_DataSize, \
				    saved_obj_info[n].data_size); \
			ADBG_EXPECT(c, IN_DataPosition, \
				    saved_obj_info[n].data_pos); \
			ADBG_EXPECT(c, IN_HandleFlags_Data, \
				    saved_obj_info[n].handle_flags); \
		} \
	} while (0)

#define Check_ObjectInfo(c, IN_ObjectType, IN_KeySize, IN_MaxKeySize, \
			 IN_ObjectUsage, IN_DataSize, IN_DataPosition, \
			 IN_HandleFlags_Handle, IN_HandleFlags_Data) \
	do { \
		check_saved_obj_info(c, 0, IN_ObjectType, IN_KeySize, \
				     IN_MaxKeySize, IN_ObjectUsage, \
				     IN_DataSize, IN_DataPosition, \
				     IN_HandleFlags_Data); \
		ADBG_EXPECT(c, IN_HandleFlags_Handle, 0); \
	} while (0)

#define set_handle_flag(c, vector, flag)  do { (vector) |= (flag); } while (0)
#define set_usage_flag(c, vector, flag)   do { (vector) |= (flag); } while (0)
#define clear_usage_flag(c, vector, flag) do { (vector) &= ~(flag); } while (0)
#define set_data_flag(c, vector, flag)    do { (vector) |= (flag); } while (0)
#define clear_data_flag(c, vector, flag)  do { (vector) &= ~(flag); } while (0)

static TEEC_Result Invoke_RestrictObjectUsage1(ADBG_Case_t *c,
					       TEEC_Session *sess, uint32_t cmd,
					       uint32_t obj_handle,
					       uint32_t obj_usage)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_handle, obj_usage);
}

static TEEC_Result Invoke_RestrictObjectUsage(ADBG_Case_t *c,
					      TEEC_Session *sess, uint32_t cmd,
					      uint32_t obj_handle,
					      uint32_t obj_usage)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_handle, obj_usage);
}

static TEEC_Result Invoke_ResetTransientObject(ADBG_Case_t *c,
					       TEEC_Session *sess, uint32_t cmd,
					       uint32_t obj_handle)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_handle, 0);
}

static TEEC_Result Invoke_CloseAndDeletePersistentObject1(ADBG_Case_t *c,
							  TEEC_Session *sess,
							  uint32_t cmd,
							  uint32_t obj_handle)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_handle, 0);
}

static TEEC_Result Invoke_CloseAndDeletePersistentObject(ADBG_Case_t *c,
							 TEEC_Session *sess,
							 uint32_t cmd,
							 uint32_t obj_handle)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_handle, 0);
}

static TEEC_Result Invoke_CloseObject(ADBG_Case_t *c, TEEC_Session *sess,
				      uint32_t cmd, uint32_t obj_handle)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_handle, 0);
}

static TEEC_Result Invoke_CreatePersistentObject(ADBG_Case_t *c,
						 TEEC_Session *sess,
						 uint32_t cmd,
						 uint32_t storage_id,
						 const char *obj_id,
						 uint32_t flags,
						 uint32_t attrs_obj_handle,
						 const void *initial_data,
						 size_t initial_data_len,
						 uint32_t obj_handle)
{
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	TEEC_Result res = TEE_SUCCESS;
	uint32_t org = 0;
	static TEEC_SharedMemory shm_obj_id = { };
	static TEEC_SharedMemory shm_data = { };

	shm_obj_id.size = strlen(obj_id);
	shm_obj_id.flags = TEEC_MEM_INPUT;
	res = TEEC_AllocateSharedMemory(sess->imp.ctx, &shm_obj_id);
	if (!ADBG_EXPECT_TEEC_SUCCESS(c, res))
		return res;
	memcpy(shm_obj_id.buffer, obj_id, shm_obj_id.size);

	shm_data.size = initial_data_len;
	shm_data.flags = TEEC_MEM_INPUT;
	res = TEEC_AllocateSharedMemory(sess->imp.ctx, &shm_data);
	if (!ADBG_EXPECT_TEEC_SUCCESS(c, res))
		goto out_free_obj_id;
	memcpy(shm_data.buffer, initial_data, shm_data.size);

	op.params[0].value.a = obj_handle;
	op.params[0].value.b = storage_id;
	op.params[1].value.a = flags;
	op.params[1].value.b = attrs_obj_handle;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(2, 0, &shm_obj_id,
					      shm_obj_id.size);
	SET_SHARED_MEMORY_OPERATION_PARAMETER(3, 0, &shm_data, shm_data.size);

	op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, TEEC_VALUE_INPUT,
					 TEEC_MEMREF_PARTIAL_INPUT,
					 TEEC_MEMREF_PARTIAL_INPUT);

	res = TEEC_InvokeCommand(sess, cmd, &op, &org);

	TEEC_ReleaseSharedMemory(&shm_data);
out_free_obj_id:
	TEEC_ReleaseSharedMemory(&shm_obj_id);

	return res;
}

static TEEC_Result Invoke_OpenPersistentObject(ADBG_Case_t *c,
					       TEEC_Session *sess,
					       uint32_t cmd,
					       uint32_t storage_id,
					       const char *obj_id,
					       uint32_t flags,
					       uint32_t obj_handle)
{
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	TEEC_Result res = TEE_SUCCESS;
	uint32_t org = 0;
	static TEEC_SharedMemory shm = { };

	shm.size = strlen(obj_id);
	shm.flags = TEEC_MEM_INPUT;
	res = TEEC_AllocateSharedMemory(sess->imp.ctx, &shm);
	if (!ADBG_EXPECT_TEEC_SUCCESS(c, res))
		return res;
	memcpy(shm.buffer, obj_id, shm.size);

	op.params[0].value.a = obj_handle;
	op.params[0].value.b = storage_id;
	op.params[1].value.a = flags;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(2, 0, &shm, shm.size);

	op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, TEEC_VALUE_INPUT,
					 TEEC_MEMREF_PARTIAL_INPUT, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmd, &op, &org);

	TEEC_ReleaseSharedMemory(&shm);

	return res;
}

#define add_attribute(c, vector, attr) do { (vector) |= BIT((attr)); } while (0)

static uint32_t get_attribute_and_advance(uint32_t attr_list, size_t *n)
{
	while (*n < 32) {
		size_t bit_idx = *n;

		(*n)++;
		if (attr_list & BIT(bit_idx))
			return bit_idx;
	}

	return ATTRIBUTE_NONE;
}

static TEEC_Result Invoke_PopulateTransientObject(ADBG_Case_t *c,
						  TEEC_Session *sess,
						  uint32_t cmd,
						  uint32_t obj_handle,
						  uint32_t attr_list)
{
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org = 0;
	size_t n = 0;

	op.params[0].value.a = obj_handle;
	op.params[1].value.a = get_attribute_and_advance(attr_list, &n);
	op.params[1].value.b = get_attribute_and_advance(attr_list, &n);
	op.params[2].value.a = get_attribute_and_advance(attr_list, &n);
	op.params[2].value.b = get_attribute_and_advance(attr_list, &n);
	op.params[3].value.a = get_attribute_and_advance(attr_list, &n);
	op.params[3].value.b = get_attribute_and_advance(attr_list, &n);

	op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, TEEC_VALUE_INPUT,
					 TEEC_VALUE_INPUT, TEEC_VALUE_INPUT);

	return TEEC_InvokeCommand(sess, cmd, &op, &org);
}

static TEEC_Result Invoke_CopyObjectAttributes1(ADBG_Case_t *c,
						TEEC_Session *sess,
						uint32_t cmd,
						uint32_t dest_obj,
						uint32_t src_obj)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, dest_obj, src_obj);
}

static TEEC_Result Invoke_CopyObjectAttributes(ADBG_Case_t *c,
					       TEEC_Session *sess,
					       uint32_t cmd,
					       uint32_t dest_obj,
					       uint32_t src_obj)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, dest_obj, src_obj);
}

static TEEC_Result Invoke_InitValueAttribute(ADBG_Case_t *c, TEEC_Session *sess,
					     uint32_t cmd, uint32_t attr,
					     uint32_t attr_id, uint32_t a,
					     uint32_t a_size,
					     uint32_t b,
					     uint32_t b_size)
{
	return Invoke_Simple_Function_v2(c, sess, cmd, attr, attr_id, a, b);
}

static TEEC_Result Invoke_AllocatePersistentObjectEnumerator(ADBG_Case_t *c,
							     TEEC_Session *sess,
							     uint32_t cmd,
							     uint32_t obj_enum)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_enum, 0);
}

static TEEC_Result Invoke_StartPersistentObjectEnumerator(ADBG_Case_t *c,
							  TEEC_Session *sess,
							  uint32_t cmd,
							  uint32_t obj_enum,
							  uint32_t storage_id)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_enum, storage_id);
}

static TEEC_Result Invoke_ResetPersistentObjectEnumerator(ADBG_Case_t *c,
							  TEEC_Session *sess,
							  uint32_t cmd,
							  uint32_t obj_enum)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_enum, 0);
}

static TEEC_Result Invoke_GetNextPersistentObject_All(ADBG_Case_t *c,
						      TEEC_Session *sess,
						      uint32_t obj_enum,
						      uint32_t obj_info,
						      uint32_t count)
{
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	static TEEC_SharedMemory shm = { };
	TEEC_Result res = TEEC_SUCCESS;
	uint32_t org = 0;
	size_t n = 0;

	if (!ADBG_EXPECT_COMPARE_UNSIGNED(c, count, <, MAX_NUM_SAVED_OBJ_INFO))
		return TEEC_ERROR_BAD_PARAMETERS;

	shm.size = TEE_OBJECT_ID_MAX_LEN;
	shm.flags = TEEC_MEM_OUTPUT;
	res = TEEC_AllocateSharedMemory(sess->imp.ctx, &shm);
	if (!ADBG_EXPECT_TEEC_SUCCESS(c, res))
		return res;

	for (n = 0; n < count; n++) {
		memset(&op, 0, sizeof(op));
		op.params[0].value.a = obj_enum;
		op.params[0].value.b = obj_info;
		SET_SHARED_MEMORY_OPERATION_PARAMETER(2, 0, &shm, shm.size);
		op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT,
						 TEEC_VALUE_INPUT,
						 TEEC_MEMREF_PARTIAL_OUTPUT,
						 TEEC_NONE);
		res = TEEC_InvokeCommand(sess, CMD_DS_GetNextPersistentObject,
					 &op, &org);
		if (!ADBG_EXPECT_TEEC_SUCCESS(c, res))
			break;

		memcpy(&saved_obj_info[n].obj_id, shm.buffer,
		       sizeof(saved_obj_info[n].obj_id));
		saved_obj_info[n].obj_id_len = op.params[2].memref.size;

		memset(&op, 0, sizeof(op));
		op.params[0].value.a = obj_info;
		op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INOUT,
						 TEEC_VALUE_OUTPUT,
						 TEEC_VALUE_OUTPUT,
						 TEEC_VALUE_OUTPUT);
		res = TEEC_InvokeCommand(sess, CMD_DS_Retrieve_ObjectInfo,
					 &op, &org);
		if (!ADBG_EXPECT_TEEC_SUCCESS(c, res))
			break;
		saved_obj_info[n].obj_type = op.params[0].value.b;
		saved_obj_info[n].obj_size = op.params[1].value.a;
		saved_obj_info[n].max_obj_size = op.params[1].value.b;
		saved_obj_info[n].obj_usage = op.params[2].value.a;
		saved_obj_info[n].data_size = op.params[2].value.b;
		saved_obj_info[n].data_pos = op.params[3].value.a;
		saved_obj_info[n].handle_flags = op.params[3].value.b;
	}

	TEEC_ReleaseSharedMemory(&shm);
	return res;
}

static int find_saved_obj_id(const void *obj_id, size_t obj_id_len)
{
	int n = 0;

	for (n = 0; n < MAX_NUM_SAVED_OBJ_INFO; n++)
		if (obj_id_len == saved_obj_info[n].obj_id_len &&
		    !memcmp(saved_obj_info[n].obj_id, obj_id, obj_id_len))
			return n;

	return -1;
}

#define Check_EnumeratedPersistentObject(c, IN_ObjectID, IN_ObjectType, \
					 IN_KeySize, IN_MaxKeySize, \
					 IN_ObjectUsage, IN_DataSize, \
					 IN_HandleFlags_Handle, \
					 IN_HandleFlags_Data) \
	do { \
		int n = find_saved_obj_id(IN_ObjectID, strlen(IN_ObjectID)); \
		\
		if (!ADBG_EXPECT_COMPARE_SIGNED(c, n, >=, 0)) \
			break; \
		ADBG_EXPECT(c, IN_ObjectType, saved_obj_info[n].obj_type); \
		ADBG_EXPECT(c, IN_KeySize, saved_obj_info[n].obj_size); \
		ADBG_EXPECT(c, IN_MaxKeySize, saved_obj_info[n].max_obj_size); \
		ADBG_EXPECT(c, IN_DataSize, saved_obj_info[n].data_size); \
		ADBG_EXPECT(c, IN_HandleFlags_Handle | IN_HandleFlags_Data, \
			    saved_obj_info[n].handle_flags); \
	} while (0)


static TEEC_Result
Invoke_GetNextPersistentObject_ErrorChecking(ADBG_Case_t *c, TEEC_Session *sess,
					     uint32_t cmd, uint32_t obj_enum,
					     uint32_t obj_info,
					     bool obj_id_is_null,
					     bool obj_id_len_is_null)
{
	return Invoke_Simple_Function_v2(c, sess, cmd, obj_enum, obj_info,
					 obj_id_is_null, obj_id_len_is_null);
}

static TEEC_Result Invoke_FreePersistentObjectEnumerator(ADBG_Case_t *c,
							 TEEC_Session *sess,
							 uint32_t cmd,
							 uint32_t obj_enum)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_enum, 0);
}


static TEEC_Result Invoke_GenerateKey(ADBG_Case_t *c,
				      TEEC_Session *sess, uint32_t cmd,
				      uint32_t obj_handle, uint32_t key_size,
				      uint32_t attr_list)
{
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	uint32_t org = 0;
	size_t n = 0;

	op.params[0].value.a = obj_handle;
	op.params[0].value.b = key_size;

	op.params[1].value.a = get_attribute_and_advance(attr_list, &n);
	op.params[1].value.b = get_attribute_and_advance(attr_list, &n);
	op.params[2].value.a = get_attribute_and_advance(attr_list, &n);
	op.params[2].value.b = get_attribute_and_advance(attr_list, &n);

	op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, TEEC_VALUE_INPUT,
					 TEEC_VALUE_INPUT, TEEC_NONE);

	return TEEC_InvokeCommand(sess, cmd, &op, &org);
}

static TEEC_Result GetObjectValueAttribute_helper(ADBG_Case_t *c,
						  TEEC_Session *sess,
						  uint32_t n, uint32_t cmd,
						  uint32_t obj,
						  uint32_t attr_id,
						  bool extract_a,
						  bool extract_b)
{
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	TEEC_Result res = TEE_SUCCESS;
	uint32_t org = 0;

	op.params[0].value.a = obj;
	op.params[0].value.b = attr_id;
	op.params[1].value.a = extract_a;
	op.params[1].value.b = extract_b;

	op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, TEEC_VALUE_INPUT,
					 TEEC_VALUE_OUTPUT, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmd, &op, &org);

	if (!res) {
		memcpy(saved_attr[n].buf, &op.params[2].value,
		       sizeof(op.params[2].value));
		saved_attr[n].buf_size = sizeof(op.params[2].value);
		saved_attr[n].attr_id = attr_id;
	} else {
		memset(saved_attr + n, 0, sizeof(saved_attr[n]));
	}

	return res;
}

static TEEC_Result get_value_attr(ADBG_Case_t *c, TEEC_Session *sess,
				  uint32_t n, uint32_t obj, uint32_t attr_id)
{
	return GetObjectValueAttribute_helper(c, sess, n,
					      CMD_DS_GetObjectValueAttribute,
					      obj, attr_id, true, true);
}

static TEEC_Result get_buffer_attr(ADBG_Case_t *c, TEEC_Session *sess,
				   uint32_t n, uint32_t obj, uint32_t attr_id)
{
	return GetObjectBufferAttribute_helper(c, sess, n,
					       CMD_DS_GetObjectBufferAttribute,
					       obj, attr_id, false,
					       BIG_ATTRIBUTE_BUFFER_SIZE);
}

static TEEC_Result GetAttributes_helper(ADBG_Case_t *c, TEEC_Session *sess,
					uint32_t obj, const uint32_t attr_ids[],
					size_t num_attr_ids)
{
	TEEC_Result res = TEE_SUCCESS;
	size_t n = 0;

	for (n = 0; n < num_attr_ids; n++) {
		if (attr_ids[n] & BIT(29))
			res = get_value_attr(c, sess, n, obj, attr_ids[n]);
		else
			res = get_buffer_attr(c, sess, n, obj, attr_ids[n]);
		if (!ADBG_EXPECT_TEEC_SUCCESS(c, res))
			break;
	}

	return res;
}

static TEEC_Result Macro_GetDHAttributes(ADBG_Case_t *c, TEEC_Session *sess,
					 uint32_t obj)
{
	const uint32_t attrs[] = {
		TEE_ATTR_DH_PRIME, TEE_ATTR_DH_BASE,
		TEE_ATTR_DH_PUBLIC_VALUE, TEE_ATTR_DH_PRIVATE_VALUE,
		TEE_ATTR_DH_X_BITS,
	};

	return GetAttributes_helper(c, sess, obj, attrs,
				    sizeof(attrs) / sizeof(attrs[0]));
}

/* TODO check the attributes too */
#define Check_GeneratedDHAttributes(c) \
	do { ADBG_EXPECT_TRUE(c, true); } while (0)

static TEEC_Result Invoke_GetObjectValueAttribute(ADBG_Case_t *c,
						  TEEC_Session *sess,
						  uint32_t cmd, uint32_t obj,
						  uint32_t attr_id,
						  bool extract_a,
						  bool extract_b)
{
	return GetObjectValueAttribute_helper(c, sess, 0, cmd, obj,
					      attr_id, extract_a, extract_b);
}

static TEEC_Result Macro_GetRSAAttributes(ADBG_Case_t *c, TEEC_Session *sess,
					 uint32_t obj)
{
	const uint32_t attrs[] = {
		TEE_ATTR_RSA_MODULUS, TEE_ATTR_RSA_PUBLIC_EXPONENT,
		TEE_ATTR_RSA_PRIVATE_EXPONENT, TEE_ATTR_RSA_PRIME1,
		TEE_ATTR_RSA_PRIME2, TEE_ATTR_RSA_EXPONENT1,
		TEE_ATTR_RSA_EXPONENT2, TEE_ATTR_RSA_COEFFICIENT,
	};

	return GetAttributes_helper(c, sess, obj, attrs,
				    sizeof(attrs) / sizeof(attrs[0]));
}

/* TODO check the attributes too */
#define Check_GeneratedRSAAttributes(c) \
	do { ADBG_EXPECT_TRUE(c, true); } while (0)

#define Check_ObjectBufferAttribute(c, attr_buf, attr_buf_len) \
	do { \
		ADBG_EXPECT_BUFFER(c, attr_buf, attr_buf_len, \
				   saved_attr[0].buf, \
				   saved_attr[0].buf_size); \
	} while (0)

static bool check_values(uint64_t a, uint64_t b, const uint8_t buf[],
			 size_t blen)
{
	uint32_t exp_val = 0;

	if (blen != sizeof(uint32_t) * 2)
		return false;

	if (a != TEE_ATTR_VALUE_NONE) {
		memcpy(&exp_val, buf, sizeof(exp_val));
		if (a != exp_val)
			return false;
	}

	if (b != TEE_ATTR_VALUE_NONE) {
		memcpy(&exp_val, buf + sizeof(uint32_t), sizeof(exp_val));
		if (b != exp_val)
			return false;
	}

	return true;
}

#define Check_ObjectValueAttribute(c, a, a_size, b, b_size) \
	ADBG_EXPECT_TRUE(c, check_values(a, b, saved_attr[0].buf, \
					 saved_attr[0].buf_size))

static TEEC_Result Invoke_StoreBuffer(ADBG_Case_t *c, TEEC_Session *sess,
				      uint32_t cmd, uint32_t buffer,
				      const void *data, size_t size)
{
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	TEEC_Result res = TEE_SUCCESS;
	uint32_t org = 0;
	static TEEC_SharedMemory shm_data = { };
	unsigned int pt1 = 0;

	op.params[0].value.a = buffer;
	if (data) {
		shm_data.size = size;
		shm_data.flags = TEEC_MEM_INPUT;
		res = TEEC_AllocateSharedMemory(sess->imp.ctx, &shm_data);
		if (!ADBG_EXPECT_TEEC_SUCCESS(c, res))
			return res;
		memcpy(shm_data.buffer, data, shm_data.size);
		SET_SHARED_MEMORY_OPERATION_PARAMETER(1, 0, &shm_data,
						      shm_data.size);
		pt1 = TEEC_MEMREF_PARTIAL_INPUT;
	} else {
		op.params[1].value.a = size;
		pt1 = TEEC_VALUE_INPUT;
	}

	op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, pt1,
					 TEEC_NONE, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmd, &op, &org);

	TEEC_ReleaseSharedMemory(&shm_data);

	return res;
}

static TEEC_Result Invoke_SeekObjectData(ADBG_Case_t *c, TEEC_Session *sess,
					 uint32_t cmd, uint32_t obj_handle,
					 ssize_t offset, int whence)
{
	uint32_t offs;
	uint32_t offs_negative;

	if (offset >= 0) {
		offs = offset;
		offs_negative = 0;
	} else {
		offs = -offset;
		offs_negative = 1;
	}

	return Invoke_Simple_Function_v3(c, sess, cmd, obj_handle, 0,
					 offs, offs_negative, whence, 0);
}

static TEEC_Result Invoke_WriteObjectData(ADBG_Case_t *c, TEEC_Session *sess,
					  uint32_t cmd, uint32_t obj_handle,
					  uint32_t buffer)
{
	return Invoke_Simple_Function_v1(c, sess, cmd, obj_handle, buffer);
}

static TEEC_Result Invoke_TruncateObjectData(ADBG_Case_t *c, TEEC_Session *sess,
					     uint32_t cmd, uint32_t obj_handle,
					     uint32_t size)
{
	return Invoke_Simple_Function_v2(c, sess, cmd, obj_handle, 0, size, 0);
}

static TEEC_Result Invoke_StoreAttributeBuffer(ADBG_Case_t *c,
					       TEEC_Session *sess,
					       uint32_t cmd, uint32_t buffer,
					       const void *value_bufptr,
					       size_t value_size)
{
	TEEC_Operation op = TEEC_OPERATION_INITIALIZER;
	TEEC_Result res = TEE_SUCCESS;
	uint32_t org = 0;
	static TEEC_SharedMemory shm = { };

	shm.size = value_size;
	shm.flags = TEEC_MEM_INPUT;
	res = TEEC_AllocateSharedMemory(sess->imp.ctx, &shm);
	if (!ADBG_EXPECT_TEEC_SUCCESS(c, res))
		return res;
	memcpy(shm.buffer, value_bufptr, shm.size);

	op.params[0].value.a = buffer;
	SET_SHARED_MEMORY_OPERATION_PARAMETER(1, 0, &shm, shm.size);

	op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT,
					 TEEC_MEMREF_PARTIAL_INPUT,
					 TEEC_NONE, TEEC_NONE);

	res = TEEC_InvokeCommand(sess, cmd, &op, &org);

	TEEC_ReleaseSharedMemory(&shm);

	return res;
}

static TEEC_Result Invoke_InitRefAttribute(ADBG_Case_t *c, TEEC_Session *sess,
					   uint32_t cmd, uint32_t attr,
					   uint32_t attr_id, uint32_t buffer)
{
	return Invoke_Simple_Function_v2(c, sess, cmd, attr, attr_id,
					 buffer, 0);
}

static TEEC_Result
Macro_StoreRefAttribute(ADBG_Case_t *c, TEEC_Session *sess, uint32_t attr,
			uint32_t buffer, uint32_t attr_id,
			const void *value_bufptr, size_t value_size)
{
	TEEC_Result res = TEE_SUCCESS;

	res = Invoke_StoreAttributeBuffer(c, sess, CMD_DS_StoreBuffer,
					  buffer, value_bufptr, value_size);
	if (!ADBG_EXPECT_TEEC_SUCCESS(c, res))
		return res;

	res = Invoke_InitRefAttribute(c, sess, CMD_DS_InitRefAttribute,
				      attr, attr_id, buffer);
	ADBG_EXPECT_TEEC_SUCCESS(c, res);
	return res;
}



#endif /* XML_DATASTORAGE_API_H_ */
