# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=skylake-avx512 -instruction-tables < %s | FileCheck %s

vandnpd           %xmm16, %xmm17, %xmm19
vandnpd           (%rax), %xmm17, %xmm19
vandnpd           (%rax){1to2}, %xmm17, %xmm19
vandnpd           %xmm16, %xmm17, %xmm19 {k1}
vandnpd           (%rax), %xmm17, %xmm19 {k1}
vandnpd           (%rax){1to2}, %xmm17, %xmm19 {k1}
vandnpd           %xmm16, %xmm17, %xmm19 {z}{k1}
vandnpd           (%rax), %xmm17, %xmm19 {z}{k1}
vandnpd           (%rax){1to2}, %xmm17, %xmm19 {z}{k1}

vandnpd           %ymm16, %ymm17, %ymm19
vandnpd           (%rax), %ymm17, %ymm19
vandnpd           (%rax){1to4}, %ymm17, %ymm19
vandnpd           %ymm16, %ymm17, %ymm19 {k1}
vandnpd           (%rax), %ymm17, %ymm19 {k1}
vandnpd           (%rax){1to4}, %ymm17, %ymm19 {k1}
vandnpd           %ymm16, %ymm17, %ymm19 {z}{k1}
vandnpd           (%rax), %ymm17, %ymm19 {z}{k1}
vandnpd           (%rax){1to4}, %ymm17, %ymm19 {z}{k1}

vandnps           %xmm16, %xmm17, %xmm19
vandnps           (%rax), %xmm17, %xmm19
vandnps           (%rax){1to4}, %xmm17, %xmm19
vandnps           %xmm16, %xmm17, %xmm19 {k1}
vandnps           (%rax), %xmm17, %xmm19 {k1}
vandnps           (%rax){1to4}, %xmm17, %xmm19 {k1}
vandnps           %xmm16, %xmm17, %xmm19 {z}{k1}
vandnps           (%rax), %xmm17, %xmm19 {z}{k1}
vandnps           (%rax){1to4}, %xmm17, %xmm19 {z}{k1}

vandnps           %ymm16, %ymm17, %ymm19
vandnps           (%rax), %ymm17, %ymm19
vandnps           (%rax){1to8}, %ymm17, %ymm19
vandnps           %ymm16, %ymm17, %ymm19 {k1}
vandnps           (%rax), %ymm17, %ymm19 {k1}
vandnps           (%rax){1to8}, %ymm17, %ymm19 {k1}
vandnps           %ymm16, %ymm17, %ymm19 {z}{k1}
vandnps           (%rax), %ymm17, %ymm19 {z}{k1}
vandnps           (%rax){1to8}, %ymm17, %ymm19 {z}{k1}

vandpd            %xmm16, %xmm17, %xmm19
vandpd            (%rax), %xmm17, %xmm19
vandpd            (%rax){1to2}, %xmm17, %xmm19
vandpd            %xmm16, %xmm17, %xmm19 {k1}
vandpd            (%rax), %xmm17, %xmm19 {k1}
vandpd            (%rax){1to2}, %xmm17, %xmm19 {k1}
vandpd            %xmm16, %xmm17, %xmm19 {z}{k1}
vandpd            (%rax), %xmm17, %xmm19 {z}{k1}
vandpd            (%rax){1to2}, %xmm17, %xmm19 {z}{k1}

vandpd            %ymm16, %ymm17, %ymm19
vandpd            (%rax), %ymm17, %ymm19
vandpd            (%rax){1to4}, %ymm17, %ymm19
vandpd            %ymm16, %ymm17, %ymm19 {k1}
vandpd            (%rax), %ymm17, %ymm19 {k1}
vandpd            (%rax){1to4}, %ymm17, %ymm19 {k1}
vandpd            %ymm16, %ymm17, %ymm19 {z}{k1}
vandpd            (%rax), %ymm17, %ymm19 {z}{k1}
vandpd            (%rax){1to4}, %ymm17, %ymm19 {z}{k1}

vandps            %xmm16, %xmm17, %xmm19
vandps            (%rax), %xmm17, %xmm19
vandps            (%rax){1to4}, %xmm17, %xmm19
vandps            %xmm16, %xmm17, %xmm19 {k1}
vandps            (%rax), %xmm17, %xmm19 {k1}
vandps            (%rax){1to4}, %xmm17, %xmm19 {k1}
vandps            %xmm16, %xmm17, %xmm19 {z}{k1}
vandps            (%rax), %xmm17, %xmm19 {z}{k1}
vandps            (%rax){1to4}, %xmm17, %xmm19 {z}{k1}

vandps            %ymm16, %ymm17, %ymm19
vandps            (%rax), %ymm17, %ymm19
vandps            (%rax){1to8}, %ymm17, %ymm19
vandps            %ymm16, %ymm17, %ymm19 {k1}
vandps            (%rax), %ymm17, %ymm19 {k1}
vandps            (%rax){1to8}, %ymm17, %ymm19 {k1}
vandps            %ymm16, %ymm17, %ymm19 {z}{k1}
vandps            (%rax), %ymm17, %ymm19 {z}{k1}
vandps            (%rax){1to8}, %ymm17, %ymm19 {z}{k1}

vbroadcastf32x2   %xmm16, %ymm19
vbroadcastf32x2   (%rax), %ymm19
vbroadcastf32x2   %xmm16, %ymm19 {k1}
vbroadcastf32x2   (%rax), %ymm19 {k1}
vbroadcastf32x2   %xmm16, %ymm19 {z}{k1}
vbroadcastf32x2   (%rax), %ymm19 {z}{k1}

vbroadcastf64x2   (%rax), %ymm19
vbroadcastf64x2   (%rax), %ymm19 {k1}
vbroadcastf64x2   (%rax), %ymm19 {z}{k1}

vbroadcasti32x2   %xmm16, %xmm19
vbroadcasti32x2   (%rax), %xmm19
vbroadcasti32x2   %xmm16, %xmm19 {k1}
vbroadcasti32x2   (%rax), %xmm19 {k1}
vbroadcasti32x2   %xmm16, %xmm19 {z}{k1}
vbroadcasti32x2   (%rax), %xmm19 {z}{k1}

vbroadcasti32x2   %xmm16, %ymm19
vbroadcasti32x2   (%rax), %ymm19
vbroadcasti32x2   %xmm16, %ymm19 {k1}
vbroadcasti32x2   (%rax), %ymm19 {k1}
vbroadcasti32x2   %xmm16, %ymm19 {z}{k1}
vbroadcasti32x2   (%rax), %ymm19 {z}{k1}

vbroadcasti64x2   (%rax), %ymm19
vbroadcasti64x2   (%rax), %ymm19 {k1}
vbroadcasti64x2   (%rax), %ymm19 {z}{k1}

vcvtpd2qq         %xmm16, %xmm19
vcvtpd2qq         (%rax), %xmm19
vcvtpd2qq         (%rax){1to2}, %xmm19
vcvtpd2qq         %xmm16, %xmm19 {k1}
vcvtpd2qq         (%rax), %xmm19 {k1}
vcvtpd2qq         (%rax){1to2}, %xmm19 {k1}
vcvtpd2qq         %xmm16, %xmm19 {z}{k1}
vcvtpd2qq         (%rax), %xmm19 {z}{k1}
vcvtpd2qq         (%rax){1to2}, %xmm19 {z}{k1}

vcvtpd2qq         %ymm16, %ymm19
vcvtpd2qq         (%rax), %ymm19
vcvtpd2qq         (%rax){1to4}, %ymm19
vcvtpd2qq         %ymm16, %ymm19 {k1}
vcvtpd2qq         (%rax), %ymm19 {k1}
vcvtpd2qq         (%rax){1to4}, %ymm19 {k1}
vcvtpd2qq         %ymm16, %ymm19 {z}{k1}
vcvtpd2qq         (%rax), %ymm19 {z}{k1}
vcvtpd2qq         (%rax){1to4}, %ymm19 {z}{k1}

vcvtpd2uqq        %xmm16, %xmm19
vcvtpd2uqq        (%rax), %xmm19
vcvtpd2uqq        (%rax){1to2}, %xmm19
vcvtpd2uqq        %xmm16, %xmm19 {k1}
vcvtpd2uqq        (%rax), %xmm19 {k1}
vcvtpd2uqq        (%rax){1to2}, %xmm19 {k1}
vcvtpd2uqq        %xmm16, %xmm19 {z}{k1}
vcvtpd2uqq        (%rax), %xmm19 {z}{k1}
vcvtpd2uqq        (%rax){1to2}, %xmm19 {z}{k1}

vcvtpd2uqq        %ymm16, %ymm19
vcvtpd2uqq        (%rax), %ymm19
vcvtpd2uqq        (%rax){1to4}, %ymm19
vcvtpd2uqq        %ymm16, %ymm19 {k1}
vcvtpd2uqq        (%rax), %ymm19 {k1}
vcvtpd2uqq        (%rax){1to4}, %ymm19 {k1}
vcvtpd2uqq        %ymm16, %ymm19 {z}{k1}
vcvtpd2uqq        (%rax), %ymm19 {z}{k1}
vcvtpd2uqq        (%rax){1to4}, %ymm19 {z}{k1}

vcvtps2qq         %xmm16, %xmm19
vcvtps2qq         (%rax), %xmm19
vcvtps2qq         (%rax){1to2}, %xmm19
vcvtps2qq         %xmm16, %xmm19 {k1}
vcvtps2qq         (%rax), %xmm19 {k1}
vcvtps2qq         (%rax){1to2}, %xmm19 {k1}
vcvtps2qq         %xmm16, %xmm19 {z}{k1}
vcvtps2qq         (%rax), %xmm19 {z}{k1}
vcvtps2qq         (%rax){1to2}, %xmm19 {z}{k1}

vcvtps2qq         %xmm16, %ymm19
vcvtps2qq         (%rax), %ymm19
vcvtps2qq         (%rax){1to4}, %ymm19
vcvtps2qq         %xmm16, %ymm19 {k1}
vcvtps2qq         (%rax), %ymm19 {k1}
vcvtps2qq         (%rax){1to4}, %ymm19 {k1}
vcvtps2qq         %xmm16, %ymm19 {z}{k1}
vcvtps2qq         (%rax), %ymm19 {z}{k1}
vcvtps2qq         (%rax){1to4}, %ymm19 {z}{k1}

vcvtps2uqq        %xmm16, %xmm19
vcvtps2uqq        (%rax), %xmm19
vcvtps2uqq        (%rax){1to2}, %xmm19
vcvtps2uqq        %xmm16, %xmm19 {k1}
vcvtps2uqq        (%rax), %xmm19 {k1}
vcvtps2uqq        (%rax){1to2}, %xmm19 {k1}
vcvtps2uqq        %xmm16, %xmm19 {z}{k1}
vcvtps2uqq        (%rax), %xmm19 {z}{k1}
vcvtps2uqq        (%rax){1to2}, %xmm19 {z}{k1}

vcvtps2uqq        %xmm16, %ymm19
vcvtps2uqq        (%rax), %ymm19
vcvtps2uqq        (%rax){1to4}, %ymm19
vcvtps2uqq        %xmm16, %ymm19 {k1}
vcvtps2uqq        (%rax), %ymm19 {k1}
vcvtps2uqq        (%rax){1to4}, %ymm19 {k1}
vcvtps2uqq        %xmm16, %ymm19 {z}{k1}
vcvtps2uqq        (%rax), %ymm19 {z}{k1}
vcvtps2uqq        (%rax){1to4}, %ymm19 {z}{k1}

vcvtqq2pd         %xmm16, %xmm19
vcvtqq2pd         (%rax), %xmm19
vcvtqq2pd         (%rax){1to2}, %xmm19
vcvtqq2pd         %xmm16, %xmm19 {k1}
vcvtqq2pd         (%rax), %xmm19 {k1}
vcvtqq2pd         (%rax){1to2}, %xmm19 {k1}
vcvtqq2pd         %xmm16, %xmm19 {z}{k1}
vcvtqq2pd         (%rax), %xmm19 {z}{k1}
vcvtqq2pd         (%rax){1to2}, %xmm19 {z}{k1}

vcvtqq2pd         %ymm16, %ymm19
vcvtqq2pd         (%rax), %ymm19
vcvtqq2pd         (%rax){1to4}, %ymm19
vcvtqq2pd         %ymm16, %ymm19 {k1}
vcvtqq2pd         (%rax), %ymm19 {k1}
vcvtqq2pd         (%rax){1to4}, %ymm19 {k1}
vcvtqq2pd         %ymm16, %ymm19 {z}{k1}
vcvtqq2pd         (%rax), %ymm19 {z}{k1}
vcvtqq2pd         (%rax){1to4}, %ymm19 {z}{k1}

vcvtqq2ps         %xmm16, %xmm19
vcvtqq2psx        (%rax), %xmm19
vcvtqq2ps         (%rax){1to2}, %xmm19
vcvtqq2ps         %xmm16, %xmm19 {k1}
vcvtqq2psx        (%rax), %xmm19 {k1}
vcvtqq2ps         (%rax){1to2}, %xmm19 {k1}
vcvtqq2ps         %xmm16, %xmm19 {z}{k1}
vcvtqq2psx        (%rax), %xmm19 {z}{k1}
vcvtqq2ps         (%rax){1to2}, %xmm19 {z}{k1}

vcvtqq2ps         %ymm16, %xmm19
vcvtqq2psx        (%rax), %xmm19
vcvtqq2ps         (%rax){1to4}, %xmm19
vcvtqq2ps         %ymm16, %xmm19 {k1}
vcvtqq2psx        (%rax), %xmm19 {k1}
vcvtqq2ps         (%rax){1to4}, %xmm19 {k1}
vcvtqq2ps         %ymm16, %xmm19 {z}{k1}
vcvtqq2psx        (%rax), %xmm19 {z}{k1}
vcvtqq2ps         (%rax){1to4}, %xmm19 {z}{k1}

vcvttpd2qq        %xmm16, %xmm19
vcvttpd2qq        (%rax), %xmm19
vcvttpd2qq        (%rax){1to2}, %xmm19
vcvttpd2qq        %xmm16, %xmm19 {k1}
vcvttpd2qq        (%rax), %xmm19 {k1}
vcvttpd2qq        (%rax){1to2}, %xmm19 {k1}
vcvttpd2qq        %xmm16, %xmm19 {z}{k1}
vcvttpd2qq        (%rax), %xmm19 {z}{k1}
vcvttpd2qq        (%rax){1to2}, %xmm19 {z}{k1}

vcvttpd2qq        %ymm16, %ymm19
vcvttpd2qq        (%rax), %ymm19
vcvttpd2qq        (%rax){1to4}, %ymm19
vcvttpd2qq        %ymm16, %ymm19 {k1}
vcvttpd2qq        (%rax), %ymm19 {k1}
vcvttpd2qq        (%rax){1to4}, %ymm19 {k1}
vcvttpd2qq        %ymm16, %ymm19 {z}{k1}
vcvttpd2qq        (%rax), %ymm19 {z}{k1}
vcvttpd2qq        (%rax){1to4}, %ymm19 {z}{k1}

vcvttpd2uqq       %xmm16, %xmm19
vcvttpd2uqq       (%rax), %xmm19
vcvttpd2uqq       (%rax){1to2}, %xmm19
vcvttpd2uqq       %xmm16, %xmm19 {k1}
vcvttpd2uqq       (%rax), %xmm19 {k1}
vcvttpd2uqq       (%rax){1to2}, %xmm19 {k1}
vcvttpd2uqq       %xmm16, %xmm19 {z}{k1}
vcvttpd2uqq       (%rax), %xmm19 {z}{k1}
vcvttpd2uqq       (%rax){1to2}, %xmm19 {z}{k1}

vcvttpd2uqq       %ymm16, %ymm19
vcvttpd2uqq       (%rax), %ymm19
vcvttpd2uqq       (%rax){1to4}, %ymm19
vcvttpd2uqq       %ymm16, %ymm19 {k1}
vcvttpd2uqq       (%rax), %ymm19 {k1}
vcvttpd2uqq       (%rax){1to4}, %ymm19 {k1}
vcvttpd2uqq       %ymm16, %ymm19 {z}{k1}
vcvttpd2uqq       (%rax), %ymm19 {z}{k1}
vcvttpd2uqq       (%rax){1to4}, %ymm19 {z}{k1}

vcvttps2qq        %xmm16, %xmm19
vcvttps2qq        (%rax), %xmm19
vcvttps2qq        (%rax){1to2}, %xmm19
vcvttps2qq        %xmm16, %xmm19 {k1}
vcvttps2qq        (%rax), %xmm19 {k1}
vcvttps2qq        (%rax){1to2}, %xmm19 {k1}
vcvttps2qq        %xmm16, %xmm19 {z}{k1}
vcvttps2qq        (%rax), %xmm19 {z}{k1}
vcvttps2qq        (%rax){1to2}, %xmm19 {z}{k1}

vcvttps2qq        %xmm16, %ymm19
vcvttps2qq        (%rax), %ymm19
vcvttps2qq        (%rax){1to4}, %ymm19
vcvttps2qq        %xmm16, %ymm19 {k1}
vcvttps2qq        (%rax), %ymm19 {k1}
vcvttps2qq        (%rax){1to4}, %ymm19 {k1}
vcvttps2qq        %xmm16, %ymm19 {z}{k1}
vcvttps2qq        (%rax), %ymm19 {z}{k1}
vcvttps2qq        (%rax){1to4}, %ymm19 {z}{k1}

vcvttps2uqq       %xmm16, %xmm19
vcvttps2uqq       (%rax), %xmm19
vcvttps2uqq       (%rax){1to2}, %xmm19
vcvttps2uqq       %xmm16, %xmm19 {k1}
vcvttps2uqq       (%rax), %xmm19 {k1}
vcvttps2uqq       (%rax){1to2}, %xmm19 {k1}
vcvttps2uqq       %xmm16, %xmm19 {z}{k1}
vcvttps2uqq       (%rax), %xmm19 {z}{k1}
vcvttps2uqq       (%rax){1to2}, %xmm19 {z}{k1}

vcvttps2uqq       %xmm16, %ymm19
vcvttps2uqq       (%rax), %ymm19
vcvttps2uqq       (%rax){1to4}, %ymm19
vcvttps2uqq       %xmm16, %ymm19 {k1}
vcvttps2uqq       (%rax), %ymm19 {k1}
vcvttps2uqq       (%rax){1to4}, %ymm19 {k1}
vcvttps2uqq       %xmm16, %ymm19 {z}{k1}
vcvttps2uqq       (%rax), %ymm19 {z}{k1}
vcvttps2uqq       (%rax){1to4}, %ymm19 {z}{k1}

vcvtuqq2pd        %xmm16, %xmm19
vcvtuqq2pd        (%rax), %xmm19
vcvtuqq2pd        (%rax){1to2}, %xmm19
vcvtuqq2pd        %xmm16, %xmm19 {k1}
vcvtuqq2pd        (%rax), %xmm19 {k1}
vcvtuqq2pd        (%rax){1to2}, %xmm19 {k1}
vcvtuqq2pd        %xmm16, %xmm19 {z}{k1}
vcvtuqq2pd        (%rax), %xmm19 {z}{k1}
vcvtuqq2pd        (%rax){1to2}, %xmm19 {z}{k1}

vcvtuqq2pd        %ymm16, %ymm19
vcvtuqq2pd        (%rax), %ymm19
vcvtuqq2pd        (%rax){1to4}, %ymm19
vcvtuqq2pd        %ymm16, %ymm19 {k1}
vcvtuqq2pd        (%rax), %ymm19 {k1}
vcvtuqq2pd        (%rax){1to4}, %ymm19 {k1}
vcvtuqq2pd        %ymm16, %ymm19 {z}{k1}
vcvtuqq2pd        (%rax), %ymm19 {z}{k1}
vcvtuqq2pd        (%rax){1to4}, %ymm19 {z}{k1}

vcvtuqq2ps        %xmm16, %xmm19
vcvtuqq2psx       (%rax), %xmm19
vcvtuqq2ps        (%rax){1to2}, %xmm19
vcvtuqq2ps        %xmm16, %xmm19 {k1}
vcvtuqq2psx       (%rax), %xmm19 {k1}
vcvtuqq2ps        (%rax){1to2}, %xmm19 {k1}
vcvtuqq2ps        %xmm16, %xmm19 {z}{k1}
vcvtuqq2psx       (%rax), %xmm19 {z}{k1}
vcvtuqq2ps        (%rax){1to2}, %xmm19 {z}{k1}

vcvtuqq2ps        %ymm16, %xmm19
vcvtuqq2psx       (%rax), %xmm19
vcvtuqq2ps        (%rax){1to4}, %xmm19
vcvtuqq2ps        %ymm16, %xmm19 {k1}
vcvtuqq2psx       (%rax), %xmm19 {k1}
vcvtuqq2ps        (%rax){1to4}, %xmm19 {k1}
vcvtuqq2ps        %ymm16, %xmm19 {z}{k1}
vcvtuqq2psx       (%rax), %xmm19 {z}{k1}
vcvtuqq2ps        (%rax){1to4}, %xmm19 {z}{k1}

vextractf64x2     $1, %ymm16, %xmm19
vextractf64x2     $1, %ymm16, (%rax)
vextractf64x2     $1, %ymm16, %xmm19 {k1}
vextractf64x2     $1, %ymm16, (%rax) {k1}
vextractf64x2     $1, %ymm16, %xmm19 {z}{k1}

vextracti64x2     $1, %ymm16, %xmm19
vextracti64x2     $1, %ymm16, (%rax)
vextracti64x2     $1, %ymm16, %xmm19 {k1}
vextracti64x2     $1, %ymm16, (%rax) {k1}
vextracti64x2     $1, %ymm16, %xmm19 {z}{k1}

vfpclasspd        $0xab, %xmm16, %k1
vfpclasspdx       $0xab, (%rax), %k1
vfpclasspdx       $0xab, (%rax){1to2}, %k1
vfpclasspd        $0xab, %xmm16, %k1 {k2}
vfpclasspdx       $0xab, (%rax), %k1 {k2}
vfpclasspdx       $0xab, (%rax){1to2}, %k1 {k2}

vfpclasspd        $0xab, %ymm16, %k1
vfpclasspdy       $0xab, (%rax), %k1
vfpclasspdy       $0xab, (%rax){1to4}, %k1
vfpclasspd        $0xab, %ymm16, %k1 {k2}
vfpclasspdy       $0xab, (%rax), %k1 {k2}
vfpclasspdy       $0xab, (%rax){1to4}, %k1 {k2}

vfpclassps        $0xab, %xmm16, %k1
vfpclasspsx       $0xab, (%rax), %k1
vfpclasspsx       $0xab, (%rax){1to4}, %k1
vfpclassps        $0xab, %xmm16, %k1 {k2}
vfpclasspsx       $0xab, (%rax), %k1 {k2}
vfpclasspsx       $0xab, (%rax){1to4}, %k1 {k2}

vfpclassps        $0xab, %ymm16, %k1
vfpclasspsy       $0xab, (%rax), %k1
vfpclasspsy       $0xab, (%rax){1to8}, %k1
vfpclassps        $0xab, %ymm16, %k1 {k2}
vfpclasspsy       $0xab, (%rax), %k1 {k2}
vfpclasspsy       $0xab, (%rax){1to8}, %k1 {k2}

vinsertf64x2      $1, %xmm16, %ymm16, %ymm19
vinsertf64x2      $1, (%rax), %ymm16, %ymm19
vinsertf64x2      $1, %xmm16, %ymm16, %ymm19 {k1}
vinsertf64x2      $1, (%rax), %ymm16, %ymm19 {k1}
vinsertf64x2      $1, %xmm16, %ymm16, %ymm19 {z}{k1}
vinsertf64x2      $1, (%rax), %ymm16, %ymm19 {z}{k1}

vinserti64x2      $1, %xmm16, %ymm16, %ymm19
vinserti64x2      $1, (%rax), %ymm16, %ymm19
vinserti64x2      $1, %xmm16, %ymm16, %ymm19 {k1}
vinserti64x2      $1, (%rax), %ymm16, %ymm19 {k1}
vinserti64x2      $1, %xmm16, %ymm16, %ymm19 {z}{k1}
vinserti64x2      $1, (%rax), %ymm16, %ymm19 {z}{k1}

vpmovm2d          %k0, %xmm0
vpmovm2q          %k0, %xmm0

vpmovm2d          %k0, %ymm0
vpmovm2q          %k0, %ymm0

vpmovd2m          %xmm0, %k0
vpmovq2m          %xmm0, %k0

vpmovd2m          %ymm0, %k0
vpmovq2m          %ymm0, %k0

vorpd             %xmm16, %xmm17, %xmm19
vorpd             (%rax), %xmm17, %xmm19
vorpd             (%rax){1to2}, %xmm17, %xmm19
vorpd             %xmm16, %xmm17, %xmm19 {k1}
vorpd             (%rax), %xmm17, %xmm19 {k1}
vorpd             (%rax){1to2}, %xmm17, %xmm19 {k1}
vorpd             %xmm16, %xmm17, %xmm19 {z}{k1}
vorpd             (%rax), %xmm17, %xmm19 {z}{k1}
vorpd             (%rax){1to2}, %xmm17, %xmm19 {z}{k1}

vorpd             %ymm16, %ymm17, %ymm19
vorpd             (%rax), %ymm17, %ymm19
vorpd             (%rax){1to4}, %ymm17, %ymm19
vorpd             %ymm16, %ymm17, %ymm19 {k1}
vorpd             (%rax), %ymm17, %ymm19 {k1}
vorpd             (%rax){1to4}, %ymm17, %ymm19 {k1}
vorpd             %ymm16, %ymm17, %ymm19 {z}{k1}
vorpd             (%rax), %ymm17, %ymm19 {z}{k1}
vorpd             (%rax){1to4}, %ymm17, %ymm19 {z}{k1}

vorps             %xmm16, %xmm17, %xmm19
vorps             (%rax), %xmm17, %xmm19
vorps             (%rax){1to4}, %xmm17, %xmm19
vorps             %xmm16, %xmm17, %xmm19 {k1}
vorps             (%rax), %xmm17, %xmm19 {k1}
vorps             (%rax){1to4}, %xmm17, %xmm19 {k1}
vorps             %xmm16, %xmm17, %xmm19 {z}{k1}
vorps             (%rax), %xmm17, %xmm19 {z}{k1}
vorps             (%rax){1to4}, %xmm17, %xmm19 {z}{k1}

vorps             %ymm16, %ymm17, %ymm19
vorps             (%rax), %ymm17, %ymm19
vorps             (%rax){1to8}, %ymm17, %ymm19
vorps             %ymm16, %ymm17, %ymm19 {k1}
vorps             (%rax), %ymm17, %ymm19 {k1}
vorps             (%rax){1to8}, %ymm17, %ymm19 {k1}
vorps             %ymm16, %ymm17, %ymm19 {z}{k1}
vorps             (%rax), %ymm17, %ymm19 {z}{k1}
vorps             (%rax){1to8}, %ymm17, %ymm19 {z}{k1}

vpmullq           %xmm16, %xmm17, %xmm19
vpmullq           (%rax), %xmm17, %xmm19
vpmullq           %xmm16, %xmm17, %xmm19 {k1}
vpmullq           (%rax), %xmm17, %xmm19 {k1}
vpmullq           %xmm16, %xmm17, %xmm19 {z}{k1}
vpmullq           (%rax), %xmm17, %xmm19 {z}{k1}

vpmullq           %ymm16, %ymm17, %ymm19
vpmullq           (%rax), %ymm17, %ymm19
vpmullq           %ymm16, %ymm17, %ymm19 {k1}
vpmullq           (%rax), %ymm17, %ymm19 {k1}
vpmullq           %ymm16, %ymm17, %ymm19 {z}{k1}
vpmullq           (%rax), %ymm17, %ymm19 {z}{k1}

vrangepd          $ab, %xmm16, %xmm17, %xmm19
vrangepd          $ab, (%rax), %xmm17, %xmm19
vrangepd          $ab, (%rax){1to2}, %xmm17, %xmm19
vrangepd          $ab, %xmm16, %xmm17, %xmm19 {k1}
vrangepd          $ab, (%rax), %xmm17, %xmm19 {k1}
vrangepd          $ab, (%rax){1to2}, %xmm17, %xmm19 {k1}
vrangepd          $ab, %xmm16, %xmm17, %xmm19 {z}{k1}
vrangepd          $ab, (%rax), %xmm17, %xmm19 {z}{k1}
vrangepd          $ab, (%rax){1to2}, %xmm17, %xmm19 {z}{k1}

vrangepd          $ab, %ymm16, %ymm17, %ymm19
vrangepd          $ab, (%rax), %ymm17, %ymm19
vrangepd          $ab, (%rax){1to4}, %ymm17, %ymm19
vrangepd          $ab, %ymm16, %ymm17, %ymm19 {k1}
vrangepd          $ab, (%rax), %ymm17, %ymm19 {k1}
vrangepd          $ab, (%rax){1to4}, %ymm17, %ymm19 {k1}
vrangepd          $ab, %ymm16, %ymm17, %ymm19 {z}{k1}
vrangepd          $ab, (%rax), %ymm17, %ymm19 {z}{k1}
vrangepd          $ab, (%rax){1to4}, %ymm17, %ymm19 {z}{k1}

vrangeps          $ab, %xmm16, %xmm17, %xmm19
vrangeps          $ab, (%rax), %xmm17, %xmm19
vrangeps          $ab, (%rax){1to4}, %xmm17, %xmm19
vrangeps          $ab, %xmm16, %xmm17, %xmm19 {k1}
vrangeps          $ab, (%rax), %xmm17, %xmm19 {k1}
vrangeps          $ab, (%rax){1to4}, %xmm17, %xmm19 {k1}
vrangeps          $ab, %xmm16, %xmm17, %xmm19 {z}{k1}
vrangeps          $ab, (%rax), %xmm17, %xmm19 {z}{k1}
vrangeps          $ab, (%rax){1to4}, %xmm17, %xmm19 {z}{k1}

vrangeps          $ab, %ymm16, %ymm17, %ymm19
vrangeps          $ab, (%rax), %ymm17, %ymm19
vrangeps          $ab, (%rax){1to8}, %ymm17, %ymm19
vrangeps          $ab, %ymm16, %ymm17, %ymm19 {k1}
vrangeps          $ab, (%rax), %ymm17, %ymm19 {k1}
vrangeps          $ab, (%rax){1to8}, %ymm17, %ymm19 {k1}
vrangeps          $ab, %ymm16, %ymm17, %ymm19 {z}{k1}
vrangeps          $ab, (%rax), %ymm17, %ymm19 {z}{k1}
vrangeps          $ab, (%rax){1to8}, %ymm17, %ymm19 {z}{k1}

vreducepd         $ab, %xmm16, %xmm19
vreducepd         $ab, (%rax), %xmm19
vreducepd         $ab, (%rax){1to2}, %xmm19
vreducepd         $ab, %xmm16, %xmm19 {k1}
vreducepd         $ab, (%rax), %xmm19 {k1}
vreducepd         $ab, (%rax){1to2}, %xmm19 {k1}
vreducepd         $ab, %xmm16, %xmm19 {z}{k1}
vreducepd         $ab, (%rax), %xmm19 {z}{k1}
vreducepd         $ab, (%rax){1to2}, %xmm19 {z}{k1}

vreducepd         $ab, %ymm16, %ymm19
vreducepd         $ab, (%rax), %ymm19
vreducepd         $ab, (%rax){1to4}, %ymm19
vreducepd         $ab, %ymm16, %ymm19 {k1}
vreducepd         $ab, (%rax), %ymm19 {k1}
vreducepd         $ab, (%rax){1to4}, %ymm19 {k1}
vreducepd         $ab, %ymm16, %ymm19 {z}{k1}
vreducepd         $ab, (%rax), %ymm19 {z}{k1}
vreducepd         $ab, (%rax){1to4}, %ymm19 {z}{k1}

vreduceps         $ab, %xmm16, %xmm19
vreduceps         $ab, (%rax), %xmm19
vreduceps         $ab, (%rax){1to4}, %xmm19
vreduceps         $ab, %xmm16, %xmm19 {k1}
vreduceps         $ab, (%rax), %xmm19 {k1}
vreduceps         $ab, (%rax){1to4}, %xmm19 {k1}
vreduceps         $ab, %xmm16, %xmm19 {z}{k1}
vreduceps         $ab, (%rax), %xmm19 {z}{k1}
vreduceps         $ab, (%rax){1to4}, %xmm19 {z}{k1}

vreduceps         $ab, %ymm16, %ymm19
vreduceps         $ab, (%rax), %ymm19
vreduceps         $ab, (%rax){1to8}, %ymm19
vreduceps         $ab, %ymm16, %ymm19 {k1}
vreduceps         $ab, (%rax), %ymm19 {k1}
vreduceps         $ab, (%rax){1to8}, %ymm19 {k1}
vreduceps         $ab, %ymm16, %ymm19 {z}{k1}
vreduceps         $ab, (%rax), %ymm19 {z}{k1}
vreduceps         $ab, (%rax){1to8}, %ymm19 {z}{k1}

vxorpd            %xmm16, %xmm17, %xmm19
vxorpd            (%rax), %xmm17, %xmm19
vxorpd            (%rax){1to2}, %xmm17, %xmm19
vxorpd            %xmm16, %xmm17, %xmm19 {k1}
vxorpd            (%rax), %xmm17, %xmm19 {k1}
vxorpd            (%rax){1to2}, %xmm17, %xmm19 {k1}
vxorpd            %xmm16, %xmm17, %xmm19 {z}{k1}
vxorpd            (%rax), %xmm17, %xmm19 {z}{k1}
vxorpd            (%rax){1to2}, %xmm17, %xmm19 {z}{k1}

vxorpd            %ymm16, %ymm17, %ymm19
vxorpd            (%rax), %ymm17, %ymm19
vxorpd            (%rax){1to4}, %ymm17, %ymm19
vxorpd            %ymm16, %ymm17, %ymm19 {k1}
vxorpd            (%rax), %ymm17, %ymm19 {k1}
vxorpd            (%rax){1to4}, %ymm17, %ymm19 {k1}
vxorpd            %ymm16, %ymm17, %ymm19 {z}{k1}
vxorpd            (%rax), %ymm17, %ymm19 {z}{k1}
vxorpd            (%rax){1to4}, %ymm17, %ymm19 {z}{k1}

vxorps            %xmm16, %xmm17, %xmm19
vxorps            (%rax), %xmm17, %xmm19
vxorps            (%rax){1to4}, %xmm17, %xmm19
vxorps            %xmm16, %xmm17, %xmm19 {k1}
vxorps            (%rax), %xmm17, %xmm19 {k1}
vxorps            (%rax){1to4}, %xmm17, %xmm19 {k1}
vxorps            %xmm16, %xmm17, %xmm19 {z}{k1}
vxorps            (%rax), %xmm17, %xmm19 {z}{k1}
vxorps            (%rax){1to4}, %xmm17, %xmm19 {z}{k1}

vxorps            %ymm16, %ymm17, %ymm19
vxorps            (%rax), %ymm17, %ymm19
vxorps            (%rax){1to8}, %ymm17, %ymm19
vxorps            %ymm16, %ymm17, %ymm19 {k1}
vxorps            (%rax), %ymm17, %ymm19 {k1}
vxorps            (%rax){1to8}, %ymm17, %ymm19 {k1}
vxorps            %ymm16, %ymm17, %ymm19 {z}{k1}
vxorps            (%rax), %ymm17, %ymm19 {z}{k1}
vxorps            (%rax){1to8}, %ymm17, %ymm19 {z}{k1}

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.33                        vandnpd	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vandnpd	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vandnpd	(%rax){1to2}, %xmm17, %xmm19
# CHECK-NEXT:  1      1     0.33                        vandnpd	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vandnpd	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vandnpd	(%rax){1to2}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vandnpd	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vandnpd	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vandnpd	(%rax){1to2}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vandnpd	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vandnpd	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vandnpd	(%rax){1to4}, %ymm17, %ymm19
# CHECK-NEXT:  1      1     0.33                        vandnpd	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vandnpd	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vandnpd	(%rax){1to4}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vandnpd	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vandnpd	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vandnpd	(%rax){1to4}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vandnps	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vandnps	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vandnps	(%rax){1to4}, %xmm17, %xmm19
# CHECK-NEXT:  1      1     0.33                        vandnps	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vandnps	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vandnps	(%rax){1to4}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vandnps	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vandnps	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vandnps	(%rax){1to4}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vandnps	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vandnps	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vandnps	(%rax){1to8}, %ymm17, %ymm19
# CHECK-NEXT:  1      1     0.33                        vandnps	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vandnps	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vandnps	(%rax){1to8}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vandnps	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vandnps	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vandnps	(%rax){1to8}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vandpd	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vandpd	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vandpd	(%rax){1to2}, %xmm17, %xmm19
# CHECK-NEXT:  1      1     0.33                        vandpd	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vandpd	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vandpd	(%rax){1to2}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vandpd	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vandpd	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vandpd	(%rax){1to2}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vandpd	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vandpd	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vandpd	(%rax){1to4}, %ymm17, %ymm19
# CHECK-NEXT:  1      1     0.33                        vandpd	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vandpd	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vandpd	(%rax){1to4}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vandpd	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vandpd	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vandpd	(%rax){1to4}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vandps	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vandps	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vandps	(%rax){1to4}, %xmm17, %xmm19
# CHECK-NEXT:  1      1     0.33                        vandps	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vandps	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vandps	(%rax){1to4}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vandps	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vandps	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vandps	(%rax){1to4}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vandps	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vandps	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vandps	(%rax){1to8}, %ymm17, %ymm19
# CHECK-NEXT:  1      1     0.33                        vandps	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vandps	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vandps	(%rax){1to8}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vandps	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vandps	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vandps	(%rax){1to8}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vbroadcastf32x2	%xmm16, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vbroadcastf32x2	(%rax), %ymm19
# CHECK-NEXT:  1      3     1.00                        vbroadcastf32x2	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vbroadcastf32x2	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vbroadcastf32x2	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vbroadcastf32x2	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vbroadcastf64x2	(%rax), %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vbroadcastf64x2	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vbroadcastf64x2	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vbroadcasti32x2	%xmm16, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vbroadcasti32x2	(%rax), %xmm19
# CHECK-NEXT:  1      1     1.00                        vbroadcasti32x2	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vbroadcasti32x2	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vbroadcasti32x2	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vbroadcasti32x2	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vbroadcasti32x2	%xmm16, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vbroadcasti32x2	(%rax), %ymm19
# CHECK-NEXT:  1      3     1.00                        vbroadcasti32x2	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vbroadcasti32x2	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vbroadcasti32x2	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vbroadcasti32x2	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vbroadcasti64x2	(%rax), %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vbroadcasti64x2	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vbroadcasti64x2	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvtpd2qq	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2qq	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2qq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  1      4     0.50                        vcvtpd2qq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2qq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2qq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvtpd2qq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2qq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2qq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvtpd2qq	%ymm16, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2qq	(%rax), %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2qq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  1      4     0.50                        vcvtpd2qq	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2qq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2qq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvtpd2qq	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2qq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2qq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvtpd2uqq	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2uqq	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2uqq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  1      4     0.50                        vcvtpd2uqq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2uqq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2uqq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvtpd2uqq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2uqq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtpd2uqq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvtpd2uqq	%ymm16, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2uqq	(%rax), %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2uqq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  1      4     0.50                        vcvtpd2uqq	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2uqq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2uqq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvtpd2uqq	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2uqq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtpd2uqq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      5     1.00                        vcvtps2qq	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2qq	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2qq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  2      5     1.00                        vcvtps2qq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2qq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2qq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  2      5     1.00                        vcvtps2qq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2qq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2qq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     1.00                        vcvtps2qq	%xmm16, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2qq	(%rax), %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2qq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  2      7     1.00                        vcvtps2qq	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2qq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2qq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  2      7     1.00                        vcvtps2qq	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2qq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2qq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      5     1.00                        vcvtps2uqq	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2uqq	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2uqq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  2      5     1.00                        vcvtps2uqq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2uqq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2uqq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  2      5     1.00                        vcvtps2uqq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2uqq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtps2uqq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     1.00                        vcvtps2uqq	%xmm16, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2uqq	(%rax), %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2uqq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  2      7     1.00                        vcvtps2uqq	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2uqq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2uqq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  2      7     1.00                        vcvtps2uqq	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2uqq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtps2uqq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvtqq2pd	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2pd	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2pd	(%rax){1to2}, %xmm19
# CHECK-NEXT:  1      4     0.50                        vcvtqq2pd	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2pd	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2pd	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvtqq2pd	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2pd	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2pd	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvtqq2pd	%ymm16, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtqq2pd	(%rax), %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtqq2pd	(%rax){1to4}, %ymm19
# CHECK-NEXT:  1      4     0.50                        vcvtqq2pd	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtqq2pd	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtqq2pd	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvtqq2pd	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtqq2pd	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtqq2pd	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      5     1.00                        vcvtqq2ps	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2psx	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2ps	(%rax){1to2}, %xmm19
# CHECK-NEXT:  2      5     1.00                        vcvtqq2ps	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2psx	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2ps	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  2      5     1.00                        vcvtqq2ps	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2psx	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2ps	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     1.00                        vcvtqq2ps	%ymm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2psx	(%rax), %xmm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtqq2ps	(%rax){1to4}, %xmm19
# CHECK-NEXT:  2      7     1.00                        vcvtqq2ps	%ymm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2psx	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtqq2ps	(%rax){1to4}, %xmm19 {%k1}
# CHECK-NEXT:  2      7     1.00                        vcvtqq2ps	%ymm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtqq2psx	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtqq2ps	(%rax){1to4}, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvttpd2qq	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2qq	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2qq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  1      4     0.50                        vcvttpd2qq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2qq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2qq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvttpd2qq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2qq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2qq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvttpd2qq	%ymm16, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2qq	(%rax), %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2qq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  1      4     0.50                        vcvttpd2qq	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2qq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2qq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvttpd2qq	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2qq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2qq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvttpd2uqq	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2uqq	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2uqq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  1      4     0.50                        vcvttpd2uqq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2uqq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2uqq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvttpd2uqq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2uqq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvttpd2uqq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvttpd2uqq	%ymm16, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2uqq	(%rax), %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2uqq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  1      4     0.50                        vcvttpd2uqq	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2uqq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2uqq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvttpd2uqq	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2uqq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvttpd2uqq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      5     1.00                        vcvttps2qq	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2qq	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2qq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  2      5     1.00                        vcvttps2qq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2qq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2qq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  2      5     1.00                        vcvttps2qq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2qq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2qq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     1.00                        vcvttps2qq	%xmm16, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2qq	(%rax), %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2qq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  2      7     1.00                        vcvttps2qq	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2qq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2qq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  2      7     1.00                        vcvttps2qq	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2qq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2qq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      5     1.00                        vcvttps2uqq	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2uqq	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2uqq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  2      5     1.00                        vcvttps2uqq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2uqq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2uqq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  2      5     1.00                        vcvttps2uqq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2uqq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvttps2uqq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     1.00                        vcvttps2uqq	%xmm16, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2uqq	(%rax), %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2uqq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  2      7     1.00                        vcvttps2uqq	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2uqq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2uqq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  2      7     1.00                        vcvttps2uqq	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2uqq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvttps2uqq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvtuqq2pd	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2pd	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2pd	(%rax){1to2}, %xmm19
# CHECK-NEXT:  1      4     0.50                        vcvtuqq2pd	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2pd	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2pd	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvtuqq2pd	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2pd	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2pd	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vcvtuqq2pd	%ymm16, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtuqq2pd	(%rax), %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtuqq2pd	(%rax){1to4}, %ymm19
# CHECK-NEXT:  1      4     0.50                        vcvtuqq2pd	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtuqq2pd	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtuqq2pd	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vcvtuqq2pd	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtuqq2pd	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtuqq2pd	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      5     1.00                        vcvtuqq2ps	%xmm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2psx	(%rax), %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2ps	(%rax){1to2}, %xmm19
# CHECK-NEXT:  2      5     1.00                        vcvtuqq2ps	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2psx	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2ps	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  2      5     1.00                        vcvtuqq2ps	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2psx	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2ps	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     1.00                        vcvtuqq2ps	%ymm16, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2psx	(%rax), %xmm19
# CHECK-NEXT:  2      11    0.50    *                   vcvtuqq2ps	(%rax){1to4}, %xmm19
# CHECK-NEXT:  2      7     1.00                        vcvtuqq2ps	%ymm16, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2psx	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vcvtuqq2ps	(%rax){1to4}, %xmm19 {%k1}
# CHECK-NEXT:  2      7     1.00                        vcvtuqq2ps	%ymm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vcvtuqq2psx	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vcvtuqq2ps	(%rax){1to4}, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vextractf64x2	$1, %ymm16, %xmm19
# CHECK-NEXT:  2      1     1.00                        vextractf64x2	$1, %ymm16, (%rax)
# CHECK-NEXT:  1      3     1.00                        vextractf64x2	$1, %ymm16, %xmm19 {%k1}
# CHECK-NEXT:  2      1     1.00           *            vextractf64x2	$1, %ymm16, (%rax) {%k1}
# CHECK-NEXT:  1      3     1.00                        vextractf64x2	$1, %ymm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vextracti64x2	$1, %ymm16, %xmm19
# CHECK-NEXT:  2      1     1.00                        vextracti64x2	$1, %ymm16, (%rax)
# CHECK-NEXT:  1      3     1.00                        vextracti64x2	$1, %ymm16, %xmm19 {%k1}
# CHECK-NEXT:  2      1     1.00           *            vextracti64x2	$1, %ymm16, (%rax) {%k1}
# CHECK-NEXT:  1      3     1.00                        vextracti64x2	$1, %ymm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      4     1.00                        vfpclasspd	$171, %xmm16, %k1
# CHECK-NEXT:  2      10    1.00    *                   vfpclasspdx	$171, (%rax), %k1
# CHECK-NEXT:  2      10    1.00    *                   vfpclasspd	$171, (%rax){1to2}, %k1
# CHECK-NEXT:  1      4     1.00                        vfpclasspd	$171, %xmm16, %k1 {%k2}
# CHECK-NEXT:  2      10    1.00    *                   vfpclasspdx	$171, (%rax), %k1 {%k2}
# CHECK-NEXT:  2      10    1.00    *                   vfpclasspd	$171, (%rax){1to2}, %k1 {%k2}
# CHECK-NEXT:  1      4     1.00                        vfpclasspd	$171, %ymm16, %k1
# CHECK-NEXT:  2      11    1.00    *                   vfpclasspdy	$171, (%rax), %k1
# CHECK-NEXT:  2      11    1.00    *                   vfpclasspd	$171, (%rax){1to4}, %k1
# CHECK-NEXT:  1      4     1.00                        vfpclasspd	$171, %ymm16, %k1 {%k2}
# CHECK-NEXT:  2      11    1.00    *                   vfpclasspdy	$171, (%rax), %k1 {%k2}
# CHECK-NEXT:  2      11    1.00    *                   vfpclasspd	$171, (%rax){1to4}, %k1 {%k2}
# CHECK-NEXT:  1      4     1.00                        vfpclassps	$171, %xmm16, %k1
# CHECK-NEXT:  2      10    1.00    *                   vfpclasspsx	$171, (%rax), %k1
# CHECK-NEXT:  2      10    1.00    *                   vfpclassps	$171, (%rax){1to4}, %k1
# CHECK-NEXT:  1      4     1.00                        vfpclassps	$171, %xmm16, %k1 {%k2}
# CHECK-NEXT:  2      10    1.00    *                   vfpclasspsx	$171, (%rax), %k1 {%k2}
# CHECK-NEXT:  2      10    1.00    *                   vfpclassps	$171, (%rax){1to4}, %k1 {%k2}
# CHECK-NEXT:  1      4     1.00                        vfpclassps	$171, %ymm16, %k1
# CHECK-NEXT:  2      11    1.00    *                   vfpclasspsy	$171, (%rax), %k1
# CHECK-NEXT:  2      11    1.00    *                   vfpclassps	$171, (%rax){1to8}, %k1
# CHECK-NEXT:  1      4     1.00                        vfpclassps	$171, %ymm16, %k1 {%k2}
# CHECK-NEXT:  2      11    1.00    *                   vfpclasspsy	$171, (%rax), %k1 {%k2}
# CHECK-NEXT:  2      11    1.00    *                   vfpclassps	$171, (%rax){1to8}, %k1 {%k2}
# CHECK-NEXT:  1      3     1.00                        vinsertf64x2	$1, %xmm16, %ymm16, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vinsertf64x2	$1, (%rax), %ymm16, %ymm19
# CHECK-NEXT:  1      3     1.00                        vinsertf64x2	$1, %xmm16, %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vinsertf64x2	$1, (%rax), %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vinsertf64x2	$1, %xmm16, %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vinsertf64x2	$1, (%rax), %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vinserti64x2	$1, %xmm16, %ymm16, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vinserti64x2	$1, (%rax), %ymm16, %ymm19
# CHECK-NEXT:  1      3     1.00                        vinserti64x2	$1, %xmm16, %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vinserti64x2	$1, (%rax), %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vinserti64x2	$1, %xmm16, %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vinserti64x2	$1, (%rax), %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vpmovm2d	%k0, %xmm0
# CHECK-NEXT:  1      1     0.33                        vpmovm2q	%k0, %xmm0
# CHECK-NEXT:  1      1     0.33                        vpmovm2d	%k0, %ymm0
# CHECK-NEXT:  1      1     0.33                        vpmovm2q	%k0, %ymm0
# CHECK-NEXT:  1      1     1.00                        vpmovd2m	%xmm0, %k0
# CHECK-NEXT:  1      1     1.00                        vpmovq2m	%xmm0, %k0
# CHECK-NEXT:  1      1     1.00                        vpmovd2m	%ymm0, %k0
# CHECK-NEXT:  1      1     1.00                        vpmovq2m	%ymm0, %k0
# CHECK-NEXT:  1      1     0.33                        vorpd	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vorpd	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vorpd	(%rax){1to2}, %xmm17, %xmm19
# CHECK-NEXT:  1      1     0.33                        vorpd	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vorpd	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vorpd	(%rax){1to2}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vorpd	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vorpd	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vorpd	(%rax){1to2}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vorpd	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vorpd	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vorpd	(%rax){1to4}, %ymm17, %ymm19
# CHECK-NEXT:  1      1     0.33                        vorpd	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vorpd	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vorpd	(%rax){1to4}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vorpd	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vorpd	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vorpd	(%rax){1to4}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vorps	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vorps	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vorps	(%rax){1to4}, %xmm17, %xmm19
# CHECK-NEXT:  1      1     0.33                        vorps	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vorps	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vorps	(%rax){1to4}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vorps	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vorps	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vorps	(%rax){1to4}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vorps	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vorps	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vorps	(%rax){1to8}, %ymm17, %ymm19
# CHECK-NEXT:  1      1     0.33                        vorps	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vorps	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vorps	(%rax){1to8}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vorps	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vorps	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vorps	(%rax){1to8}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  3      15    1.50                        vpmullq	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  4      21    1.50    *                   vpmullq	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  3      15    1.50                        vpmullq	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  4      21    1.50    *                   vpmullq	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  3      15    1.50                        vpmullq	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  4      21    1.50    *                   vpmullq	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  3      15    1.50                        vpmullq	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  4      22    1.50    *                   vpmullq	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  3      15    1.50                        vpmullq	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  4      22    1.50    *                   vpmullq	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  3      15    1.50                        vpmullq	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  4      22    1.50    *                   vpmullq	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vrangepd	$ab, %xmm16, %xmm17, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vrangepd	$ab, (%rax), %xmm17, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vrangepd	$ab, (%rax){1to2}, %xmm17, %xmm19
# CHECK-NEXT:  1      4     0.50                        vrangepd	$ab, %xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vrangepd	$ab, (%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vrangepd	$ab, (%rax){1to2}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vrangepd	$ab, %xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vrangepd	$ab, (%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vrangepd	$ab, (%rax){1to2}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vrangepd	$ab, %ymm16, %ymm17, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vrangepd	$ab, (%rax), %ymm17, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vrangepd	$ab, (%rax){1to4}, %ymm17, %ymm19
# CHECK-NEXT:  1      4     0.50                        vrangepd	$ab, %ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vrangepd	$ab, (%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vrangepd	$ab, (%rax){1to4}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vrangepd	$ab, %ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vrangepd	$ab, (%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vrangepd	$ab, (%rax){1to4}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vrangeps	$ab, %xmm16, %xmm17, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vrangeps	$ab, (%rax), %xmm17, %xmm19
# CHECK-NEXT:  2      10    0.50    *                   vrangeps	$ab, (%rax){1to4}, %xmm17, %xmm19
# CHECK-NEXT:  1      4     0.50                        vrangeps	$ab, %xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vrangeps	$ab, (%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      10    0.50    *                   vrangeps	$ab, (%rax){1to4}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vrangeps	$ab, %xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vrangeps	$ab, (%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      10    0.50    *                   vrangeps	$ab, (%rax){1to4}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      4     0.50                        vrangeps	$ab, %ymm16, %ymm17, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vrangeps	$ab, (%rax), %ymm17, %ymm19
# CHECK-NEXT:  2      11    0.50    *                   vrangeps	$ab, (%rax){1to8}, %ymm17, %ymm19
# CHECK-NEXT:  1      4     0.50                        vrangeps	$ab, %ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vrangeps	$ab, (%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      11    0.50    *                   vrangeps	$ab, (%rax){1to8}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  1      4     0.50                        vrangeps	$ab, %ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vrangeps	$ab, (%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      11    0.50    *                   vrangeps	$ab, (%rax){1to8}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00                        vreducepd	$ab, %xmm16, %xmm19
# CHECK-NEXT:  3      14    1.00    *                   vreducepd	$ab, (%rax), %xmm19
# CHECK-NEXT:  3      14    1.00    *                   vreducepd	$ab, (%rax){1to2}, %xmm19
# CHECK-NEXT:  2      8     1.00                        vreducepd	$ab, %xmm16, %xmm19 {%k1}
# CHECK-NEXT:  3      14    1.00    *                   vreducepd	$ab, (%rax), %xmm19 {%k1}
# CHECK-NEXT:  3      14    1.00    *                   vreducepd	$ab, (%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  2      8     1.00                        vreducepd	$ab, %xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  3      14    1.00    *                   vreducepd	$ab, (%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  3      14    1.00    *                   vreducepd	$ab, (%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00                        vreducepd	$ab, %ymm16, %ymm19
# CHECK-NEXT:  3      15    1.00    *                   vreducepd	$ab, (%rax), %ymm19
# CHECK-NEXT:  3      15    1.00    *                   vreducepd	$ab, (%rax){1to4}, %ymm19
# CHECK-NEXT:  2      8     1.00                        vreducepd	$ab, %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  3      15    1.00    *                   vreducepd	$ab, (%rax), %ymm19 {%k1}
# CHECK-NEXT:  3      15    1.00    *                   vreducepd	$ab, (%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  2      8     1.00                        vreducepd	$ab, %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  3      15    1.00    *                   vreducepd	$ab, (%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  3      15    1.00    *                   vreducepd	$ab, (%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00                        vreduceps	$ab, %xmm16, %xmm19
# CHECK-NEXT:  3      14    1.00    *                   vreduceps	$ab, (%rax), %xmm19
# CHECK-NEXT:  3      14    1.00    *                   vreduceps	$ab, (%rax){1to4}, %xmm19
# CHECK-NEXT:  2      8     1.00                        vreduceps	$ab, %xmm16, %xmm19 {%k1}
# CHECK-NEXT:  3      14    1.00    *                   vreduceps	$ab, (%rax), %xmm19 {%k1}
# CHECK-NEXT:  3      14    1.00    *                   vreduceps	$ab, (%rax){1to4}, %xmm19 {%k1}
# CHECK-NEXT:  2      8     1.00                        vreduceps	$ab, %xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  3      14    1.00    *                   vreduceps	$ab, (%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  3      14    1.00    *                   vreduceps	$ab, (%rax){1to4}, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00                        vreduceps	$ab, %ymm16, %ymm19
# CHECK-NEXT:  3      15    1.00    *                   vreduceps	$ab, (%rax), %ymm19
# CHECK-NEXT:  3      15    1.00    *                   vreduceps	$ab, (%rax){1to8}, %ymm19
# CHECK-NEXT:  2      8     1.00                        vreduceps	$ab, %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  3      15    1.00    *                   vreduceps	$ab, (%rax), %ymm19 {%k1}
# CHECK-NEXT:  3      15    1.00    *                   vreduceps	$ab, (%rax){1to8}, %ymm19 {%k1}
# CHECK-NEXT:  2      8     1.00                        vreduceps	$ab, %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  3      15    1.00    *                   vreduceps	$ab, (%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  3      15    1.00    *                   vreduceps	$ab, (%rax){1to8}, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vxorpd	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vxorpd	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vxorpd	(%rax){1to2}, %xmm17, %xmm19
# CHECK-NEXT:  1      1     0.33                        vxorpd	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vxorpd	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vxorpd	(%rax){1to2}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vxorpd	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vxorpd	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vxorpd	(%rax){1to2}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vxorpd	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vxorpd	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vxorpd	(%rax){1to4}, %ymm17, %ymm19
# CHECK-NEXT:  1      1     0.33                        vxorpd	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vxorpd	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vxorpd	(%rax){1to4}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vxorpd	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vxorpd	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vxorpd	(%rax){1to4}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vxorps	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vxorps	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vxorps	(%rax){1to4}, %xmm17, %xmm19
# CHECK-NEXT:  1      1     0.33                        vxorps	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vxorps	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  2      7     0.50    *                   vxorps	(%rax){1to4}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vxorps	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vxorps	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  2      7     0.50    *                   vxorps	(%rax){1to4}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vxorps	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vxorps	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  2      8     0.50    *                   vxorps	(%rax){1to8}, %ymm17, %ymm19
# CHECK-NEXT:  1      1     0.33                        vxorps	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vxorps	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vxorps	(%rax){1to8}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  1      1     0.33                        vxorps	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vxorps	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vxorps	(%rax){1to8}, %ymm17, %ymm19 {%k1} {z}

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SKXDivider
# CHECK-NEXT: [1]   - SKXFPDivider
# CHECK-NEXT: [2]   - SKXPort0
# CHECK-NEXT: [3]   - SKXPort1
# CHECK-NEXT: [4]   - SKXPort2
# CHECK-NEXT: [5]   - SKXPort3
# CHECK-NEXT: [6]   - SKXPort4
# CHECK-NEXT: [7]   - SKXPort5
# CHECK-NEXT: [8]   - SKXPort6
# CHECK-NEXT: [9]   - SKXPort7

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]
# CHECK-NEXT:  -      -     240.33 236.33 166.83 166.83 4.00   137.33  -     1.33

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    Instructions:
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnpd	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax){1to2}, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnpd	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax){1to2}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnpd	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax){1to2}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnpd	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax){1to4}, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnpd	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax){1to4}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnpd	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnpd	(%rax){1to4}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnps	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax){1to4}, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnps	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax){1to4}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnps	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax){1to4}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnps	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax){1to8}, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnps	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax){1to8}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandnps	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandnps	(%rax){1to8}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandpd	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax){1to2}, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandpd	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax){1to2}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandpd	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax){1to2}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandpd	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax){1to4}, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandpd	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax){1to4}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandpd	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandpd	(%rax){1to4}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandps	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax){1to4}, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandps	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax){1to4}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandps	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax){1to4}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandps	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax){1to8}, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandps	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax){1to8}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vandps	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vandps	(%rax){1to8}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vbroadcastf32x2	%xmm16, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcastf32x2	(%rax), %ymm19
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vbroadcastf32x2	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcastf32x2	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vbroadcastf32x2	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcastf32x2	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcastf64x2	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcastf64x2	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcastf64x2	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vbroadcasti32x2	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcasti32x2	(%rax), %xmm19
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vbroadcasti32x2	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcasti32x2	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vbroadcasti32x2	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcasti32x2	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vbroadcasti32x2	%xmm16, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcasti32x2	(%rax), %ymm19
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vbroadcasti32x2	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcasti32x2	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vbroadcasti32x2	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcasti32x2	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcasti64x2	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcasti64x2	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vbroadcasti64x2	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2qq	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2qq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2qq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2qq	%ymm16, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2qq	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2qq	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2qq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2uqq	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2uqq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2uqq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2uqq	%ymm16, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2uqq	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtpd2uqq	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtpd2uqq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2qq	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2qq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2qq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2qq	%xmm16, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2qq	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2qq	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2qq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2uqq	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2uqq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2uqq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2uqq	%xmm16, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2uqq	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtps2uqq	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtps2uqq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtqq2pd	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtqq2pd	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtqq2pd	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtqq2pd	%ymm16, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtqq2pd	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtqq2pd	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2pd	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtqq2ps	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2psx	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2ps	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtqq2ps	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2psx	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2ps	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtqq2ps	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2psx	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2ps	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtqq2ps	%ymm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2psx	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2ps	(%rax){1to4}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtqq2ps	%ymm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2psx	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2ps	(%rax){1to4}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtqq2ps	%ymm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2psx	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtqq2ps	(%rax){1to4}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2qq	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2qq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2qq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2qq	%ymm16, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2qq	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2qq	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2qq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2uqq	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2uqq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2uqq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2uqq	%ymm16, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2uqq	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvttpd2uqq	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttpd2uqq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2qq	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2qq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2qq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2qq	%xmm16, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2qq	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2qq	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2qq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2uqq	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2uqq	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2uqq	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2uqq	%xmm16, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2uqq	%xmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvttps2uqq	%xmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvttps2uqq	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtuqq2pd	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtuqq2pd	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtuqq2pd	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtuqq2pd	%ymm16, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax), %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtuqq2pd	%ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vcvtuqq2pd	%ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2pd	(%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtuqq2ps	%xmm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2psx	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2ps	(%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtuqq2ps	%xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2psx	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2ps	(%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtuqq2ps	%xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2psx	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2ps	(%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtuqq2ps	%ymm16, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2psx	(%rax), %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2ps	(%rax){1to4}, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtuqq2ps	%ymm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2psx	(%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2ps	(%rax){1to4}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     1.00    -      -     vcvtuqq2ps	%ymm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2psx	(%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vcvtuqq2ps	(%rax){1to4}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vextractf64x2	$1, %ymm16, %xmm19
# CHECK-NEXT:  -      -      -      -     0.33   0.33   1.00    -      -     0.33   vextractf64x2	$1, %ymm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vextractf64x2	$1, %ymm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -      -      -     0.33   0.33   1.00    -      -     0.33   vextractf64x2	$1, %ymm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vextractf64x2	$1, %ymm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vextracti64x2	$1, %ymm16, %xmm19
# CHECK-NEXT:  -      -      -      -     0.33   0.33   1.00    -      -     0.33   vextracti64x2	$1, %ymm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vextracti64x2	$1, %ymm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -      -      -     0.33   0.33   1.00    -      -     0.33   vextracti64x2	$1, %ymm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vextracti64x2	$1, %ymm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vfpclasspd	$171, %xmm16, %k1
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspdx	$171, (%rax), %k1
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspd	$171, (%rax){1to2}, %k1
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vfpclasspd	$171, %xmm16, %k1 {%k2}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspdx	$171, (%rax), %k1 {%k2}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspd	$171, (%rax){1to2}, %k1 {%k2}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vfpclasspd	$171, %ymm16, %k1
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspdy	$171, (%rax), %k1
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspd	$171, (%rax){1to4}, %k1
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vfpclasspd	$171, %ymm16, %k1 {%k2}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspdy	$171, (%rax), %k1 {%k2}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspd	$171, (%rax){1to4}, %k1 {%k2}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vfpclassps	$171, %xmm16, %k1
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspsx	$171, (%rax), %k1
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclassps	$171, (%rax){1to4}, %k1
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vfpclassps	$171, %xmm16, %k1 {%k2}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspsx	$171, (%rax), %k1 {%k2}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclassps	$171, (%rax){1to4}, %k1 {%k2}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vfpclassps	$171, %ymm16, %k1
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspsy	$171, (%rax), %k1
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclassps	$171, (%rax){1to8}, %k1
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vfpclassps	$171, %ymm16, %k1 {%k2}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclasspsy	$171, (%rax), %k1 {%k2}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -     vfpclassps	$171, (%rax){1to8}, %k1 {%k2}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vinsertf64x2	$1, %xmm16, %ymm16, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vinsertf64x2	$1, (%rax), %ymm16, %ymm19
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vinsertf64x2	$1, %xmm16, %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vinsertf64x2	$1, (%rax), %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vinsertf64x2	$1, %xmm16, %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vinsertf64x2	$1, (%rax), %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vinserti64x2	$1, %xmm16, %ymm16, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vinserti64x2	$1, (%rax), %ymm16, %ymm19
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vinserti64x2	$1, %xmm16, %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vinserti64x2	$1, (%rax), %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -     vinserti64x2	$1, %xmm16, %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vinserti64x2	$1, (%rax), %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vpmovm2d	%k0, %xmm0
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vpmovm2q	%k0, %xmm0
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vpmovm2d	%k0, %ymm0
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vpmovm2q	%k0, %ymm0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -     vpmovd2m	%xmm0, %k0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -     vpmovq2m	%xmm0, %k0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -     vpmovd2m	%ymm0, %k0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -     vpmovq2m	%ymm0, %k0
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorpd	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax){1to2}, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorpd	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax){1to2}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorpd	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax){1to2}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorpd	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax){1to4}, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorpd	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax){1to4}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorpd	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorpd	(%rax){1to4}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorps	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax){1to4}, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorps	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax){1to4}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorps	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax){1to4}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorps	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax){1to8}, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorps	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax){1to8}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vorps	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vorps	(%rax){1to8}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.50   1.50    -      -      -      -      -      -     vpmullq	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     1.50   1.50   0.50   0.50    -      -      -      -     vpmullq	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     1.50   1.50    -      -      -      -      -      -     vpmullq	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     1.50   1.50   0.50   0.50    -      -      -      -     vpmullq	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     1.50   1.50    -      -      -      -      -      -     vpmullq	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.50   1.50   0.50   0.50    -      -      -      -     vpmullq	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.50   1.50    -      -      -      -      -      -     vpmullq	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     1.50   1.50   0.50   0.50    -      -      -      -     vpmullq	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     1.50   1.50    -      -      -      -      -      -     vpmullq	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     1.50   1.50   0.50   0.50    -      -      -      -     vpmullq	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     1.50   1.50    -      -      -      -      -      -     vpmullq	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.50   1.50   0.50   0.50    -      -      -      -     vpmullq	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangepd	$ab, %xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax){1to2}, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangepd	$ab, %xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax){1to2}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangepd	$ab, %xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax){1to2}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangepd	$ab, %ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax){1to4}, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangepd	$ab, %ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax){1to4}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangepd	$ab, %ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangepd	$ab, (%rax){1to4}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangeps	$ab, %xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax){1to4}, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangeps	$ab, %xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax){1to4}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangeps	$ab, %xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax){1to4}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangeps	$ab, %ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax){1to8}, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangeps	$ab, %ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax){1to8}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -     vrangeps	$ab, %ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50   0.50   0.50   0.50    -      -      -      -     vrangeps	$ab, (%rax){1to8}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreducepd	$ab, %xmm16, %xmm19
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax), %xmm19
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax){1to2}, %xmm19
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreducepd	$ab, %xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax){1to2}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreducepd	$ab, %xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax){1to2}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreducepd	$ab, %ymm16, %ymm19
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax), %ymm19
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax){1to4}, %ymm19
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreducepd	$ab, %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax){1to4}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreducepd	$ab, %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreducepd	$ab, (%rax){1to4}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreduceps	$ab, %xmm16, %xmm19
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax), %xmm19
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax){1to4}, %xmm19
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreduceps	$ab, %xmm16, %xmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax), %xmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax){1to4}, %xmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreduceps	$ab, %xmm16, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax), %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax){1to4}, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreduceps	$ab, %ymm16, %ymm19
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax), %ymm19
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax){1to8}, %ymm19
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreduceps	$ab, %ymm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax), %ymm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax){1to8}, %ymm19 {%k1}
# CHECK-NEXT:  -      -     1.00   1.00    -      -      -      -      -      -     vreduceps	$ab, %ymm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax), %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   1.00   0.50   0.50    -      -      -      -     vreduceps	$ab, (%rax){1to8}, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorpd	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax){1to2}, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorpd	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax){1to2}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorpd	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax){1to2}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorpd	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax){1to4}, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorpd	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax){1to4}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorpd	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorpd	(%rax){1to4}, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorps	%xmm16, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax), %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax){1to4}, %xmm17, %xmm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorps	%xmm16, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax), %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax){1to4}, %xmm17, %xmm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorps	%xmm16, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax), %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax){1to4}, %xmm17, %xmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorps	%ymm16, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax), %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax){1to8}, %ymm17, %ymm19
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorps	%ymm16, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax), %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax){1to8}, %ymm17, %ymm19 {%k1}
# CHECK-NEXT:  -      -     0.33   0.33    -      -      -     0.33    -      -     vxorps	%ymm16, %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax), %ymm17, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33   0.50   0.50    -     0.33    -      -     vxorps	(%rax){1to8}, %ymm17, %ymm19 {%k1} {z}
