#!/usr/bin/env python3

import importlib.util
import os

from fenrirscreenreader.core.i18n import _

# Load base configuration class
_base_path = os.path.join(os.path.dirname(__file__), "..", "config_base.py")
_spec = importlib.util.spec_from_file_location("config_base", _base_path)
_module = importlib.util.module_from_spec(_spec)
_spec.loader.exec_module(_module)
config_command = _module.config_command


class command(config_command):
    def __init__(self):
        super().__init__()

    def get_description(self):
        return "Toggle sound output on or off"

    def run(self):
        current_state = self.getBooleanSetting("sound", "enabled", True)
        new_state = self.toggleBooleanSetting("sound", "enabled")

        if new_state != current_state:
            state_text = "enabled" if new_state else "disabled"
            self.present_text(f"Sound {state_text}")
            # Only play sound if we enabled sound
            if new_state:
                self.play_sound("Accept")
        else:
            self.present_text("Failed to change sound setting")
