/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef __SPLASH_SCREEN__
#define __SPLASH_SCREEN__

// -- Core stuff
#include "CamiTKAPI.h"

#include <QWidget>
#include <QLabel>
#include <QProgressBar>
#include <QMouseEvent>

namespace camitk {
/**
 * @ingroup group_sdk_libraries_core_utils
 *
 * @brief  CamiTK application splash screen
 *
 */
class CAMITK_API SplashScreen : public QWidget {
    Q_OBJECT
public:
    /// constructor
    SplashScreen(QWidget* parent = nullptr);

    /// Set the progress bar value
    void setProgress(int value);

    // Set the message
    void showMessage(const QString& message);

// protected:
//     void mousePressEvent(QMouseEvent *event) override {
//         if (event->button() == Qt::LeftButton) {
//             m_dragPosition = event->globalPos() - frameGeometry().topLeft(); // QT6 globalPosition().toPoint()
//             event->accept();
//         }
//     }

//     void mouseMoveEvent(QMouseEvent *event) override {
//         if (event->buttons() & Qt::LeftButton) {
//             move(event->globalPos() - m_dragPosition); // QT6 globalPosition().toPoint()
//             event->accept();
//         }
//     }

//     void mouseReleaseEvent(QMouseEvent *event) override {
//         event->accept(); // Prevent unintended clicks from closing or interacting
//     }

private:
    QPoint m_dragPosition;

private:
    /// the message label below the progress bar
    QLabel* messageLabel;

    /// the splash screen progress bar
    QProgressBar* progressBar;
};

} // namespace camitk

#endif // __SPLASH_SCREEN__
