/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.manifest;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfPackageNamespace;
import org.odftoolkit.odfdom.pkg.manifest.AlgorithmElement;
import org.odftoolkit.odfdom.pkg.manifest.ChecksumAttribute;
import org.odftoolkit.odfdom.pkg.manifest.ChecksumTypeAttribute;
import org.odftoolkit.odfdom.pkg.manifest.KeyDerivationElement;
import org.odftoolkit.odfdom.pkg.manifest.StartKeyGenerationElement;

public class EncryptionDataElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfPackageNamespace.MANIFEST, "encryption-data");

    public EncryptionDataElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getChecksumAttribute() {
        ChecksumAttribute attr = (ChecksumAttribute)this.getOdfAttribute(OdfPackageNamespace.MANIFEST, "checksum");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setChecksumAttribute(String checksumValue) {
        ChecksumAttribute attr = new ChecksumAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(checksumValue);
    }

    public String getChecksumTypeAttribute() {
        ChecksumTypeAttribute attr = (ChecksumTypeAttribute)this.getOdfAttribute(OdfPackageNamespace.MANIFEST, "checksum-type");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setChecksumTypeAttribute(String checksumTypeValue) {
        ChecksumTypeAttribute attr = new ChecksumTypeAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(checksumTypeValue);
    }

    public AlgorithmElement newAlgorithmElement(String algorithmNameValue, String initialisationVectorValue) {
        AlgorithmElement manifestAlgorithm = ((OdfFileDom)this.ownerDocument).newOdfElement(AlgorithmElement.class);
        manifestAlgorithm.setAlgorithmNameAttribute(algorithmNameValue);
        manifestAlgorithm.setInitialisationVectorAttribute(initialisationVectorValue);
        this.appendChild(manifestAlgorithm);
        return manifestAlgorithm;
    }

    public KeyDerivationElement newKeyDerivationElement(int iterationCountValue, String keyDerivationNameValue, String saltValue) {
        KeyDerivationElement manifestKeyDerivation = ((OdfFileDom)this.ownerDocument).newOdfElement(KeyDerivationElement.class);
        manifestKeyDerivation.setIterationCountAttribute(iterationCountValue);
        manifestKeyDerivation.setKeyDerivationNameAttribute(keyDerivationNameValue);
        manifestKeyDerivation.setSaltAttribute(saltValue);
        this.appendChild(manifestKeyDerivation);
        return manifestKeyDerivation;
    }

    public StartKeyGenerationElement newStartKeyGenerationElement(String startKeyGenerationNameValue) {
        StartKeyGenerationElement manifestStartKeyGeneration = ((OdfFileDom)this.ownerDocument).newOdfElement(StartKeyGenerationElement.class);
        manifestStartKeyGeneration.setStartKeyGenerationNameAttribute(startKeyGenerationNameValue);
        this.appendChild(manifestStartKeyGeneration);
        return manifestStartKeyGeneration;
    }
}

