/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingestion;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.ingestion.GetStateResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class GetStateRequest
extends RequestBase
implements ToCopyableBuilder<Builder, GetStateRequest> {
    @Nonnull
    private final String index;
    @Nullable
    private final String nextToken;
    @Nullable
    private final Integer size;
    @Nullable
    private final Time timeout;
    public static final Endpoint<GetStateRequest, GetStateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetStateRequest, GetStateResponse>(request -> "GET", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/");
        SimpleEndpoint.pathEncode(request.index, buf);
        buf.append("/ingestion/_state");
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetStateResponse._DESERIALIZER);

    private GetStateRequest(Builder builder) {
        super(builder);
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.nextToken = builder.nextToken;
        this.size = builder.size;
        this.timeout = builder.timeout;
    }

    public static GetStateRequest of(Function<Builder, ObjectBuilder<GetStateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String nextToken() {
        return this.nextToken;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.nextToken != null) {
            params.put("next_token", this.nextToken);
        }
        if (this.size != null) {
            params.put("size", String.valueOf(this.size));
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Objects.hashCode(this.nextToken);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetStateRequest other = (GetStateRequest)o;
        return this.index.equals(other.index) && Objects.equals(this.nextToken, other.nextToken) && Objects.equals(this.size, other.size) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GetStateRequest> {
        private String index;
        @Nullable
        private String nextToken;
        @Nullable
        private Integer size;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(GetStateRequest o) {
            super(o);
            this.index = o.index;
            this.nextToken = o.nextToken;
            this.size = o.size;
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.index = o.index;
            this.nextToken = o.nextToken;
            this.size = o.size;
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder nextToken(@Nullable String value) {
            this.nextToken = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public GetStateRequest build() {
            this._checkSingleUse();
            return new GetStateRequest(this);
        }
    }
}

