/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceBandwidthWeighting {
    DEFAULT("default"),
    VPC_1("vpc-1"),
    EBS_1("ebs-1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceBandwidthWeighting> VALUE_MAP;
    private final String value;

    private InstanceBandwidthWeighting(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceBandwidthWeighting fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceBandwidthWeighting> knownValues() {
        EnumSet<InstanceBandwidthWeighting> knownValues = EnumSet.allOf(InstanceBandwidthWeighting.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceBandwidthWeighting.class, InstanceBandwidthWeighting::toString);
    }
}

