/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.OraCharsetDecoder;
import oracle.i18n.text.OraCharsetEncoder;
import oracle.i18n.text.converter.CharacterConverterOGS;

class OraCharsetWithConverter
extends OraCharset {
    private CharacterConverterOGS charConverter;

    OraCharsetWithConverter(String string, int n, CharacterConverterOGS characterConverterOGS) {
        super(string, n);
        this.charConverter = characterConverterOGS;
    }

    static OraCharset getInstance(String string, int n, boolean bl) {
        OraCharsetWithConverter oraCharsetWithConverter;
        if (bl) {
            CharacterConverterOGS characterConverterOGS = (CharacterConverterOGS)CharacterConverterOGS.getInstance(n);
            oraCharsetWithConverter = new OraCharsetWithConverter(string, n, characterConverterOGS);
        } else {
            oraCharsetWithConverter = new OraCharsetWithConverter(string, n, null);
        }
        return oraCharsetWithConverter;
    }

    @Override
    public CharsetDecoder newDecoder() {
        if (this.charConverter == null) {
            this.charConverter = (CharacterConverterOGS)CharacterConverterOGS.getInstance(this.oracleId);
        }
        return new OraCharsetDecoder(this, this.charConverter.getAverageRatio(), this.charConverter.getMaxRatio());
    }

    @Override
    public CharsetEncoder newEncoder() {
        if (this.charConverter == null) {
            this.charConverter = (CharacterConverterOGS)CharacterConverterOGS.getInstance(this.oracleId);
        }
        if (this.charConverter.getGroupId() == 6 || this.charConverter.getGroupId() == 3) {
            CharacterConverterOGS characterConverterOGS = this.charConverter;
            char c = characterConverterOGS.getOraChar2ByteRep();
            return new OraCharsetEncoder(this, 1.0f / this.charConverter.getAverageRatio(), this.charConverter.getMaxBytesRatio(), new byte[]{(byte)(c >>> 8), (byte)c});
        }
        return new OraCharsetEncoder(this, 1.0f / this.charConverter.getAverageRatio(), this.charConverter.getMaxBytesRatio());
    }

    @Override
    String toStringWithReplacement(byte[] byArray, int n, int n2) {
        if (this.charConverter == null) {
            this.charConverter = (CharacterConverterOGS)CharacterConverterOGS.getInstance(this.oracleId);
        }
        return this.charConverter.toUnicodeStringWithReplacement(byArray, n, n2);
    }

    @Override
    String toString(byte[] byArray, int n, int n2) throws SQLException {
        if (this.charConverter == null) {
            this.charConverter = (CharacterConverterOGS)CharacterConverterOGS.getInstance(this.oracleId);
        }
        return this.charConverter.toUnicodeString(byArray, n, n2);
    }

    @Override
    byte[] convertWithReplacement(String string) {
        if (this.charConverter == null) {
            this.charConverter = (CharacterConverterOGS)CharacterConverterOGS.getInstance(this.oracleId);
        }
        return this.charConverter.toOracleStringWithReplacement(string);
    }

    @Override
    byte[] convert(String string) throws SQLException {
        if (this.charConverter == null) {
            this.charConverter = (CharacterConverterOGS)CharacterConverterOGS.getInstance(this.oracleId);
        }
        return this.charConverter.toOracleString(string);
    }
}

