/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services.metrics.events;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerTransaction;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;

public class MicrometerUserEventMetricsEventListenerProvider
implements EventListenerProvider {
    private static final Logger logger = Logger.getLogger(MicrometerUserEventMetricsEventListenerProvider.class);
    private static final String REALM_TAG = "realm";
    private static final String IDP_TAG = "idp";
    private static final String CLIENT_ID_TAG = "client.id";
    private static final String ERROR_TAG = "error";
    private static final String EVENT_TAG = "event";
    private final boolean withIdp;
    private final boolean withRealm;
    private final boolean withClientId;
    private final HashSet<String> events;
    private final EventListenerTransaction tx = new EventListenerTransaction(null, this::countEvent);
    private final Meter.MeterProvider<Counter> meterProvider;

    public MicrometerUserEventMetricsEventListenerProvider(KeycloakSession session, boolean withIdp, boolean withRealm, boolean withClientId, HashSet<String> events, Meter.MeterProvider<Counter> meterProvider) {
        this.withIdp = withIdp;
        this.withRealm = withRealm;
        this.withClientId = withClientId;
        this.events = events;
        this.meterProvider = meterProvider;
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.tx);
    }

    public void onEvent(Event event) {
        this.tx.addEvent(event);
    }

    private void countEvent(Event event) {
        logger.debugf("Received user event of type %s in realm %s", (Object)event.getType().name(), (Object)event.getRealmName());
        String eventTag = MicrometerUserEventMetricsEventListenerProvider.format(event.getType());
        if (this.events != null && !this.events.contains(eventTag)) {
            return;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(5);
        tags.add(Tag.of((String)EVENT_TAG, (String)eventTag));
        tags.add(Tag.of((String)ERROR_TAG, (String)this.getError(event)));
        if (this.withRealm) {
            tags.add(Tag.of((String)REALM_TAG, (String)this.nullToEmpty(event.getRealmName())));
        }
        if (this.withIdp) {
            tags.add(Tag.of((String)IDP_TAG, (String)this.getIdentityProvider(event)));
        }
        if (this.withClientId) {
            tags.add(Tag.of((String)CLIENT_ID_TAG, (String)this.getClientId(event)));
        }
        ((Counter)this.meterProvider.withTags(tags)).increment();
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
    }

    private String getIdentityProvider(Event event) {
        String identityProvider = null;
        if (event.getDetails() != null) {
            identityProvider = (String)event.getDetails().get("identity_provider");
        }
        return this.nullToEmpty(identityProvider);
    }

    private String getClientId(Event event) {
        return this.nullToEmpty("client_not_found".equals(event.getError()) ? "unknown" : event.getClientId());
    }

    private String getError(Event event) {
        String error = event.getError();
        if (error == null && event.getType().name().endsWith("_ERROR")) {
            error = "unknown";
        }
        return this.nullToEmpty(error);
    }

    private String nullToEmpty(String value) {
        return value == null ? "" : value;
    }

    public static String format(EventType type) {
        String name = type.name();
        if (name.endsWith("_ERROR")) {
            name = name.substring(0, name.length() - "_ERROR".length());
        }
        return name.toLowerCase(Locale.ROOT);
    }

    public void close() {
    }
}

