/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.Point;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.plaf.DialUI;

public class Dial
extends JComponent {
    private static final String uiClassID = "DialUI";
    protected BoundedRangeModel dialModel;
    private ChangeListener changeListener;
    private ImageIcon pixmap = null;
    private ImageIcon disabledPixmap = null;
    private ImageIcon rolloverPixmap = null;
    private ImageIcon pressedPixmap = null;
    private int minAngle = 45;
    private int maxAngle = 315;
    private MouseHandlerMode mouseHandlerMode = MouseHandlerMode.RADIAL;
    private ChangeEvent changeEvent = new ChangeEvent(this);

    public Dial() {
        this(0, 100);
    }

    public Dial(int min, int max) {
        this(min, max, (min + max) / 2);
    }

    public Dial(int min, int max, int value) {
        this(new DefaultBoundedRangeModel(value, 0, min, max));
    }

    public Dial(BoundedRangeModel model) {
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Dial.this.fireStateChanged();
            }
        };
        this.setModel(model);
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public DialUI getUI() {
        return (DialUI)this.ui;
    }

    public void setUI(DialUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((DialUI)UIManager.getUI(this));
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public BoundedRangeModel getModel() {
        return this.dialModel;
    }

    public void setModel(BoundedRangeModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must be non-null");
        }
        BoundedRangeModel oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.changeListener);
        }
        this.dialModel = model;
        model.addChangeListener(this.changeListener);
        this.firePropertyChange("model", oldModel, this.dialModel);
    }

    public ImageIcon getDialPixmap() {
        return this.pixmap;
    }

    public void setDialPixmap(ImageIcon pixmap) {
        this.setDialPixmap(pixmap, 45, 315);
    }

    public void setDialPixmap(ImageIcon pixmap, int minAngle, int maxAngle) {
        if (pixmap == this.getDialPixmap()) {
            return;
        }
        this.pixmap = pixmap;
        if (minAngle < 0 || minAngle > maxAngle || maxAngle > 360) {
            throw new IllegalArgumentException("Invalid angle range");
        }
        this.minAngle = minAngle;
        this.maxAngle = maxAngle;
    }

    public int getMinimumAngle() {
        return this.minAngle;
    }

    public int getMaximumAngle() {
        return this.maxAngle;
    }

    public ImageIcon getDisabledDialPixmap() {
        return this.disabledPixmap;
    }

    public void setDisabledDialPixmap(ImageIcon pixmap) {
        this.disabledPixmap = pixmap;
    }

    public ImageIcon getRolloverDialPixmap() {
        return this.rolloverPixmap;
    }

    public void setRolloverDialPixmap(ImageIcon pixmap) {
        this.rolloverPixmap = pixmap;
    }

    public ImageIcon getPressedDialPixmap() {
        return this.pressedPixmap;
    }

    public void setPressedDialPixmap(ImageIcon pixmap) {
        this.pressedPixmap = pixmap;
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public void setMaximum(int max) {
        this.getModel().setMaximum(max);
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public void setMinimum(int min) {
        this.getModel().setMinimum(min);
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public void setValue(int value) {
        this.getModel().setValue(value);
    }

    public boolean getValueIsAdjusting() {
        return this.getModel().getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean b) {
        this.getModel().setValueIsAdjusting(b);
    }

    public MouseHandlerMode getMouseHandlerMode() {
        return this.mouseHandlerMode;
    }

    public void setMouseHandlerMode(MouseHandlerMode mouseHandlerMode) {
        this.mouseHandlerMode = mouseHandlerMode;
    }

    public int getValueByPoint(Point p) {
        return this.getUI().getValueByPoint(p);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    static {
        UIManager.put(uiClassID, "net.sf.juife.plaf.basic.BasicDialUI");
    }

    public static enum MouseHandlerMode {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        DOWN_TO_UP,
        UP_TO_DOWN,
        LEFT_TO_RIGHT_AND_DOWN_TO_UP,
        LEFT_TO_RIGHT_AND_UP_TO_DOWN,
        RIGHT_TO_LEFT_AND_DOWN_TO_UP,
        RIGHT_TO_LEFT_AND_UP_TO_DOWN,
        RADIAL;

    }
}

