/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;

class IsoIntersectGridReader
extends VolumeFileReader {
    private VolumeFileReader[] readers;
    private float[] factors;

    @Override
    protected void init(SurfaceGenerator sg) {
        this.initSR(sg);
        Object[] data = (Object[])sg.getReaderData();
        this.readers = (VolumeFileReader[])data[0];
        this.factors = (float[])data[1];
    }

    @Override
    protected boolean readVolumeParameters(boolean isMapData) {
        int i = this.readers.length;
        while (--i >= 0) {
            if (this.readers[i].readVolumeParameters(isMapData)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected float getNextVoxelValue() throws Exception {
        float f = 0.0f;
        int i = this.readers.length;
        while (--i >= 0) {
            f += this.factors[i] * this.readers[i].getNextVoxelValue();
        }
        return f;
    }

    @Override
    protected void closeReader() {
        if (this.readerClosed) {
            return;
        }
        this.readerClosed = true;
        int i = this.readers.length;
        while (--i >= 0) {
            this.readers[i].closeReaderSFR();
        }
        if (this.nData == 0 || this.dataMax == -3.4028235E38f) {
            return;
        }
        this.dataMean /= (float)this.nData;
        Logger.info("IsoIntersectFileReader closing file: " + this.nData + " points read \ndata min/max/mean = " + this.dataMin + "/" + this.dataMax + "/" + this.dataMean);
    }

    @Override
    protected void readParameters() throws Exception {
    }
}

